package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.AccessRecording;
import com.yeejoin.equipmanage.mapper.AccessRecordingMapper;
import com.yeejoin.equipmanage.service.IAccessRecordingService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.Date;

/**
 * <h1><h1>
 *
 * @author tiantao
 * @date 2021/3/1 11:56
 */
@Service
public class AccessRecordingServiceImpl extends ServiceImpl<AccessRecordingMapper, AccessRecording> implements IAccessRecordingService {

    @Override
    public Page listByParams(String accessPosition, String cardholderName, String cardCode, Integer status, Long[] crossTime, Page page) {
        QueryWrapper<AccessRecording> wrapper = getAccessRecordingQueryWrapper(accessPosition, cardholderName, cardCode, status, crossTime);
        IPage iPage = this.page(page, wrapper);
        return (Page) iPage;
    }

    private QueryWrapper<AccessRecording> getAccessRecordingQueryWrapper(String accessPosition, String cardholderName, String cardCode, Integer status, Long[] crossTime) {
        QueryWrapper<AccessRecording> wrapper = new QueryWrapper();
        if (!ValidationUtil.isEmpty(accessPosition)) {
            wrapper.eq("accessPosition", accessPosition);
        }
        if (!ValidationUtil.isEmpty(cardholderName)) {
            wrapper.like("cardholder_name", cardholderName);
        }
        if (!ValidationUtil.isEmpty(cardCode)) {
            wrapper.like("card_code", cardCode);
        }
        if (!ValidationUtil.isEmpty(status)) {
            wrapper.eq("status", status);
        }
        if (!ValidationUtil.isEmpty(crossTime)) {
            if (!ValidationUtil.isEmpty(crossTime[0])) {
                wrapper.ge("cross_time", new Date(crossTime[0]));
            }
            if (crossTime.length > 1 && !ValidationUtil.isEmpty(crossTime[1])) {
                wrapper.le("cross_time", new Date(crossTime[1]));
            }
        }
        return wrapper;
    }
}
