package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.DropDown;
import com.yeejoin.amos.boot.module.hygf.api.entity.Maintenance;
import com.yeejoin.amos.boot.module.hygf.api.entity.MaintenanceLog;
import com.yeejoin.amos.boot.module.hygf.api.entity.UnitInfo;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpStationMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.MaintenanceMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import net.sf.json.JSONObject;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.MaintenanceServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.MaintenanceDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 运维人员
 *
 * @author system_generator
 * @date 2024-03-11
 */
@RestController
@Api(tags = "运维人员Api")
@RequestMapping(value = "/maintenance")
public class MaintenanceController extends BaseController {

    @Autowired
    MaintenanceServiceImpl maintenanceServiceImpl;
    @Autowired
    JpStationMapper jpStationMapper;

    @Autowired
    MaintenanceMapper maintenanceMapper;
    /**
     * 新增运维人员
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增运维人员", notes = "新增运维人员")
    public ResponseModel<Maintenance> save(@RequestBody Maintenance model) {
        model = maintenanceServiceImpl.saveMaintenance(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新运维人员", notes = "根据sequenceNbr更新运维人员")
    public ResponseModel<MaintenanceDto> updateBySequenceNbrMaintenance(@RequestBody MaintenanceDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(maintenanceServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除运维人员", notes = "根据sequenceNbr删除运维人员")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(maintenanceServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr  主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个运维人员",  notes = "根据sequenceNbr查询单个运维人员")
    public ResponseModel<Map<String,Object> > selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(maintenanceServiceImpl.selectOneById(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET",value = "运维人员分页查询",  notes = "运维人员分页查询")
    @UserLimits
    public ResponseModel<Page<MaintenanceDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
            (value = "size") int size,
                                                         @RequestParam(required = false) String name,
                                                         @RequestParam(required = false)String maintenanceTypeCode,
                                                         @RequestParam(required = false)String maintenanceType,
                                                         @RequestParam(required = false) String lockStatus,
                                                         @RequestParam(required = false)String reviewStatus,
                                                         @RequestParam(required = false)Long regionalCompaniesSeq,
                                                         @RequestParam(required = false)Long dealerId,
                                                         @RequestParam(required = false)String maintenanceAreaAddress
    ) {
        return ResponseHelper.buildResponse(maintenanceServiceImpl.queryForMaintenancePage( current, size, name, maintenanceTypeCode,lockStatus,reviewStatus,regionalCompaniesSeq,dealerId,maintenanceType,maintenanceAreaAddress));
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping (value = "examine/{sequenceNbr}")
    @ApiOperation(httpMethod = "post",value = "审核单个运维人员",  notes = "审核单个运维人员")
    public ResponseModel<Maintenance> examine(@PathVariable Long sequenceNbr,@RequestBody MaintenanceLog maintenanceLog) {
        return ResponseHelper.buildResponse(maintenanceServiceImpl.examine(sequenceNbr,maintenanceLog));
    }






    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "运维人员列表全部数据查询",   notes = "运维人员列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<MaintenanceDto>> selectForList(
            @RequestParam(required = false) String name, //运维人员类型
            @RequestParam(required = false)String maintenanceType //运维人员类型code

    ) {
        return ResponseHelper.buildResponse(maintenanceServiceImpl.queryList(
                 name, //运维人员类型
                maintenanceType //运维人员类型code

        ));
    }



    //查询当前登录人权限经销商
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "查询当前登录人权限经销商",   notes = "查询当前登录人权限经销商")
    @GetMapping(value = "/getDealer")
    public ResponseModel<List<Map<String,String>>> getDealer(String regionalCompaniesCode ) {
        List<DropDown>  list=  jpStationMapper.getDealerNew(regionalCompaniesCode);
        List<Map<String,String>> result = new ArrayList<>();
        list.forEach(dropDown -> {
            Map<String,String> item = new HashMap<>();
            item.put("text",dropDown.getName());
            item.put("value",dropDown.getOrgCode());
            result.add(item);
        });
        return ResponseHelper.buildResponse(result);
    }


    //查询当前登录人权限经销商
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "经销商人员加入黑名单/撤销黑名单",   notes = "经销商人员加入黑名单/撤销黑名单")
    @GetMapping(value = "/updateUser")
    public ResponseModel<Object> updateUser(Long sequenceNbr ,String type) {
        maintenanceServiceImpl.updateUser( sequenceNbr , type);
        return ResponseHelper.buildResponse(null);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "签订安全协议",   notes = "签订安全协议")
    @GetMapping(value = "/updateAgreement")
    public ResponseModel<Object> updateTrainingAgreement(String userId) {
        maintenanceServiceImpl.updateTrainingAgreement(userId);
        return ResponseHelper.buildResponse(null);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "验证安全签订安全协议是否签订",   notes = "验证安全签订安全协议是否签订")
    @GetMapping(value = "/getTrainingAgreement")
    public ResponseModel<String> getTrainingAgreement(String userId) {
        MaintenanceDto maintenanceDto=maintenanceMapper.getTrainingAgreement(userId);
        if(maintenanceDto.getIsSignAnAgreement()!=null&&maintenanceDto.getIsSignAnAgreement()==1){
            return ResponseHelper.buildResponse("true");
        }
        return ResponseHelper.buildResponse("false");
    }
}
