package com.yeejoin.amos.boot.biz.common.workflow.feign;

import com.alibaba.fastjson.JSONObject;
import feign.Response;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.util.HashMap;

@FeignClient(name = "AMOS-API-WORKFLOW", path = "workflow", configuration =
		{ CommonMultipartSupportConfig.class })
public interface WorkflowFeignService {
	/**
	 * 发起流程
	 *
	 * @param params
	 * @return
	 */
	@RequestMapping(value = "/task/startProcess", method = RequestMethod.POST)
	JSONObject startByVariable(@RequestBody Object params);

	/**
	 * 以当前登录人作为任务完成人的完成任务操作
	 *
	 * @param taskID
	 * @param variable
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/task/pickupAndCompleteTask/noFromInstanceAdd/{taskId}", method = RequestMethod.POST)
	JSONObject pickupAndCompleteTask(@PathVariable("taskId") String taskID,
			@RequestBody(required = false) HashMap<String, Object> variable) throws Exception;

	/**
	 * 查询当前流程下所有的可执行任务
	 *
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/task/list/all/{processInstanceId}", method = RequestMethod.GET)
	JSONObject getTaskList(@PathVariable("processInstanceId") String processInstanceId);

	/**
	 * 查询当前任务的执行用户组
	 *
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/task/getTaskGroupName/{taskId}", method = RequestMethod.GET)
	JSONObject getTaskGroupName(@PathVariable("taskId") String taskId);

	/**
	 * 查询当前登录人可执行的任务集合，-------我的待办
	 * 
	 * @param processDefinitionKey
	 * @param userId
	 * @return
	 */
	@RequestMapping(value = "/task/all-list", method = RequestMethod.GET)
	JSONObject getTasksNoAuth(
			@RequestParam(value = "processDefinitionKey", required = false) String processDefinitionKey,
			@RequestParam(value = "userId", required = false) String userId);

	/**
	 * 查询历史流程信息
	 * 
	 * @param processDefinitionKey
	 * @param userId
	 * @return
	 */
	@RequestMapping(value = "/activitiHistory/processes/historytasks/list/{processInstanceId}", method = RequestMethod.GET)
	JSONObject queryHistoryTaskListByProcessId(@PathVariable("processInstanceId") String processInstanceId);

	/**
	 * 查询当前流程已经执行的任务
	 * 
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/activitiHistory/historyTask/{processInstanceId}", method = RequestMethod.GET)
	JSONObject queryHistoryTasksByProcessInstanceId(@PathVariable("processInstanceId") String processInstanceId);

	/**
	 * 拾取任务
	 * 
	 * @param taskID
	 * @return
	 */
	@RequestMapping(value = "/task/pickuptask/{taskID}", method = RequestMethod.PUT)
	JSONObject pickuptask(@PathVariable("taskID") String taskID);

	/**
	 * 直接完成任务
	 * 
	 * @param taskId
	 * @param variable
	 * @return
	 */
	@RequestMapping(value = "/task/complete/{taskId}", method = RequestMethod.POST)
	JSONObject completeByVariable(@PathVariable("taskId") String taskId, @RequestBody HashMap<String, Object> variable);

	/**
	 * 获取当前任务的设定执行人
	 * 
	 * @param taskId
	 * @return
	 */
	@RequestMapping(value = "/task/getTaskAssign/{taskId}", method = RequestMethod.GET)
	JSONObject getTaskAssign(@PathVariable("taskId") String taskId);

	/**
	 * 不操作FormInstance直接完成任务
	 * 
	 * @param taskID
	 * @param variable
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/task/completeTask/noFromInstanceAdd/{taskID}", method = RequestMethod.POST)
	JSONObject completeNoExecuteFromInstanceAdd(@PathVariable("taskID") String taskID,
			@RequestBody(required = false) HashMap<String, Object> variable) throws Exception;

	/**
	 * 流程图高亮
	 */
	@RequestMapping(value = "/activitiHistory/gethighLineImg/{processInstanceId}", method = RequestMethod.GET)
	Response thighLineImg(@PathVariable("processInstanceId") String processInstanceId);

	/**
	 * 流程图高亮图片
	 */
	@RequestMapping(value = "/activitiHistory/gethighLine", method = RequestMethod.GET)
	Response thighLine(@RequestParam("instanceId") String instanceId);

	/**
	 * 设置当前任务的执行组
	 * 
	 * @param taskId
	 * @param groupName
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/task/setTaskGroupName/{taskId}/{groupName}", method = RequestMethod.GET)
	JSONObject setTaskGroupName(@PathVariable("taskId") String taskId, @PathVariable("groupName") String groupName)
			throws Exception;

	/**
	 * 设置当前任务的执行人
	 * 
	 * @param taskId
	 * @param userId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/task/setTaskAssignUser/{taskId}/{userId}", method = RequestMethod.GET)
	JSONObject setTaskUser(@PathVariable("taskId") String taskId, @PathVariable("userId") String userId) throws Exception;
	/**
	 * 查询当前登录人所属角色或者id 所能执行的单个任务
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/task/")
	JSONObject getTask(@RequestParam(value="processInstanceId")  String processInstanceId);
	
	
	/**
	 * 获取当前登录人所有可以执行的任务列表
	 * @param definitionKey
	 * @return
	 * @throws Exception
	 */
	 @RequestMapping(value = "/task/getCurrentUserAllTaskList/{definitionKey}",method = RequestMethod.GET)
	 JSONObject getCurrentUserAllTaskList(@PathVariable String definitionKey) throws Exception;
	 /**
	  *  获取当前登录人所有已执行的历史任务列表
	  * @param processDefinitionKey
	  * @return
	  * @throws ParseException
	  */
	 @RequestMapping(value = "/activitiHistory/historytasks/{processDefinitionKey}",method = RequestMethod.GET)
	 JSONObject queryHistoryTasks(@PathVariable  String processDefinitionKey)throws ParseException;
	 
	   /**
	    * 获取历史流程中带有执行角色组的流程信息
	    * @param processInstanceId
	    * @return
	    * @throws ParseException
	    */
	 @RequestMapping(value = "/activitiHistory/processes/historytasks/getGroupNamelist/{taskId}",method = RequestMethod.GET)
	 JSONObject getHistoricIdentityLinksForTask(@PathVariable("taskId") String taskId) throws ParseException;
	 
	 
	/**
	 *获取指定流程定义下所有的历史流程任务任务执行信息 --获取historytask表数据
	 * @param processInstanceId
	 * @return
	 * @throws ParseException
	 */
	 @RequestMapping(value = "/activitiHistory/processes/historytasks/getHistoricTaskForProcessInstanceId/{processInstanceId}",method = RequestMethod.GET)
	 JSONObject getHistoricTaskForProcessInstanceId(@PathVariable("processInstanceId") String processInstanceId) throws ParseException;
	 
	 
	   /**'
	    * 查询指定任务名称的任务列表
	    * @param taskName
	    * @return
	    * @throws Exception
	    */
	 @RequestMapping(value = "/activitiHistory/getTaskListForTaskName/{taskName}/{definitionKey}",method = RequestMethod.GET)
	 JSONObject getTaskListForTaskName(@PathVariable String taskName,@PathVariable String definitionKey) throws Exception ;

	@RequestMapping("/v2/task/candidateGroupsUser")
	 JSONObject candidateGroupsUser(	@RequestParam(value="processDefinitionKey", required=false)  String processDefinitionKey,
										@RequestParam(value="processDefinitionId", required=false)  String processDefinitionId,
										@RequestParam("nodeKey") String nodeKey) throws Exception;
}
