package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 消防设备资产
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("ast_fire_equipment")
public class FireEquipment extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 实物id
     */
    @TableField("mrid")
    private String mrid;

    /**
     * 设备名称
     */
    @TableField("name")
    private String name;

    /**
     * 设备编码
     */
    @TableField("code")
    private String code;

    /**
     * 设备类别名称
     */
    @TableField("category_name")
    private String categoryName;

    /**
     * 设备类别编码
     */
    @TableField("category_code")
    private String categoryCode;

    /**
     * 设备图片
     */
    @TableField("img")
    private String img;

    /**
     * 设备物联编码
     */
    @TableField("iot_code")
    private String iotCode;

    /**
     * 所属区域
     */
    @TableField("work_area")
    private String workArea;

    /**
     * 所在建筑id
     */
    @TableField("build_mrid")
    private String buildMrid;

    /**
     * 所属消防系统ids
     */
    @TableField("fighting_system_mrids")
    private String fightingSystemMrids;

    /**
     * 位置
     */
    @TableField("position")
    private String position;

    /**
     * 使用日期
     */
    @TableField("in_use_date")
    private Date inUseDate;

    /**
     * 是否为物联设备：0-否；1-是
     */
    @TableField("is_iot")
    private Boolean isIot;

    /**
     * 状态
     */
    @TableField("status")
    private String status;

    /**
     * 使用状态
     */
    @TableField("in_use_state")
    private String inUseState;

    /**
     * 修改时间
     */
    @TableField("update_date")
    private Date updateDate;

    /**
     * 建筑名称
     */
    @TableField("build_name")
    private String buildName;

    /**
     * 物理区域id
     */
    @TableField("area_mrid")
    private String areaMrid;

    /**
     * 经度
     */
    @TableField("lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField("lat")
    private String lat;

}
