package com.yeejoin.equipmanage.common.datasync.enums;

/**
 * 
 * <pre>
 * 视频类型枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: VideoTypeEnum.java, v 0.1 2021年9月13日 下午5:15:54 gwb Exp $
 */
public enum VideoTypeEnum{

	BEHAVIOURAL("behavioural","行为分析摄像头"),
	SHARPEYES("sharpEyes","火眼识别摄像头"),
	OTHER("other","其他");

	/**
	 * 名称
	 */
	private String label;

	private String name;


	// 构造方法
	private VideoTypeEnum(String name, String label) {
		this.label = label;
		this.name = name;
	}


	public String getLabel() {
		return label;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static VideoTypeEnum getEnum(String name)
	{
		for (VideoTypeEnum type : VideoTypeEnum.values())
		{
			if (type.getName().equals(name))
			{
				return type;
			}
		}
		return null;
	}
}
