package com.yeejoin.equipmanage.common.enums;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author tb
 * @title: EquipmentTypeEnum
 */
public enum EquipmentTypeEnum {

    安防设备("01000000", "1"),
    消防设备("02000000", "2");

    /**
     * 设备分类编号
     */
    private String code;

    /**
     * 设备分类类型
     */
    private String type;

    EquipmentTypeEnum(String code, String type) {
        this.code = code;
        this.type = type;
    }

    public static String getCode(String type) {
        for (EquipmentTypeEnum e : EquipmentTypeEnum.values()) {
            if (e.getType().equals(type)) {
                return e.code;
            }
        }
        return null;
    }

    public static String getType(String code) {
        for (EquipmentTypeEnum e : EquipmentTypeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e.type;
            }
        }
        return null;
    }

    public static EquipmentTypeEnum getEnumByCode(String code) {
        for (EquipmentTypeEnum e : EquipmentTypeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    public static EquipmentTypeEnum getEnumByType(String type) {
        for (EquipmentTypeEnum e : EquipmentTypeEnum.values()) {
            if (e.getType().equals(type)) {
                return e;
            }
        }
        return null;
    }

    public static List<Map<String,String>> getEnumList() {
        List<Map<String, String>> enumList = new ArrayList<>();
        for (EquipmentTypeEnum c: EquipmentTypeEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", c.getCode());
            map.put("type", c.getType());
            enumList.add(map);
        }
        return enumList;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
