package com.yeejoin.equipmanage.common.enums;

public enum PressurePumpValueEnum {

    LAST_STOP("lastStop", "上次停泵时间"),
    LAST_START("lastStart", "上次启泵时间"),
    LATELY_STOP("latelyStop", "所有泵最近一次停泵时间"),
    PUMP_START_TIME("pumpStartTime", "计算启动时长"),
    LATELY_START("latelyStart", "所有泵最近一次启泵时间");

    private String code;
    private String describe;

    private PressurePumpValueEnum(String code, String describe) {
        this.code = code;
        this.describe = describe;
    }

    public String getCode() {
        return code;
    }

    public String getDescribe() {
        return describe;
    }

    public static PressurePumpValueEnum getByCode(String code) {
        for (PressurePumpValueEnum l : PressurePumpValueEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }
}
