package com.yeejoin.amos.fas.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public enum ResourceTypeDefEnum {
	riskSource("风险点","riskSource","风险点","riskSource"),
	patrol("巡检点","patrol","巡检点","patrol"),
	impEquipment("重点设备","impEquipment","重点设备","impEquipment"),
	monitorEquipment("探测器","monitorEquipment","探测器","monitorEquipment"),
	video("视频设备","video","摄像头","video"),
	hydrant("消火栓","hydrant","消防设备","fireEquipment"),
	pool("消防水池","pool","消防设备","fireEquipment"),
	fireCar("消防车","fireCar","消防设备","fireEquipment"),
	fireEquipment("灭火器材","fireEquipment","消防设备","fireEquipment"),
	fireChamber("消防小室","fireChamber","消防设备","fireEquipment"),
	fireFoamRoom("消防泡沫间","fireFoamRoom","消防设备","fireEquipment");
	
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private String typeName;

	private String typeCode;
	
	private ResourceTypeDefEnum(String name,String code,String typeName,String typeCode){
		this.name = name;
		this.code = code;
		this.typeName = typeName;
		this.typeCode = typeCode;
	}
	
	public static ResourceTypeDefEnum getEnum(String code) {
		ResourceTypeDefEnum resourceTypeDefEnum = null;
		for(ResourceTypeDefEnum type: ResourceTypeDefEnum.values()) {
			if (type.getCode().equals(code)) {
				resourceTypeDefEnum = type;
				break;
			}
		}
		
		return resourceTypeDefEnum;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(ResourceTypeDefEnum e : ResourceTypeDefEnum.values()) {
			Map<String,String> msgType = new HashMap<>();
			msgType.put(e.getCode(),e.getName());
			list.add(msgType);
		}
		return list;
	}
	
	public static List<Map<String,String>> getTypeList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(ResourceTypeDefEnum e : ResourceTypeDefEnum.values()) {
			Map<String,String> reso = new HashMap<>();
			reso.put("name",e.getTypeName());
			reso.put("code",e.getTypeCode());
			if(!list.contains(reso)){
				list.add(reso);				
			}
		}
		return list;
	}
	
	public static Boolean containsTypeCode(String typeCode) {
		Boolean flag = false;
		for(ResourceTypeDefEnum e : ResourceTypeDefEnum.values()) {
			Map<String,String> reso = new HashMap<>();
			if(e.getTypeCode().equals(typeCode)) {
				flag = true;
				break;
			}
		}
		return flag;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public String getTypeCode() {
		return typeCode;
	}

	public void setTypeCode(String typeCode) {
		this.typeCode = typeCode;
	}

}

