package com.yeejoin.amos.boot.module.jcs.api.dto;

import java.io.Serializable;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 * <pre>
 * 警情报送规则触发对象
 * </pre>
 *
 * @author gwb
 * @version $Id: AlertCalledRo.java, v 0.1 2021年6月24日 下午3:31:14 gwb Exp $
 */
@Data
@RuleFact(value = "调派信息",project = "西咸机场119调派规则")
public class AlertCallePowerTransferRo implements Serializable{
	/**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = 4681455545767986333L;

	/**
	 * 通用属性
	 */
	@Label("警情id")
    private String sequenceNbr;
	
	@Label(value = "警情时间")
    private String callTimeStr;
   
    @Label(value = "警情类型")
    private String alertType;

    @Label(value = "警情类型code")
    private String alertTypeCode;
    
    @Label(value = "发送单位")
    private String companyName;

    @Label(value = "被困人数")
    private String trappedNum;

    @Label(value = "伤亡人数")
    private String casualtiesNum;
    
    @Label(value = "地址")
    private String address;

    @Label(value = "警情报送id")
    private String alertSubmittedId;
    /**
     * 一般火灾
     */
    @Label(value = "失火位置")
    private String fireLocation;
    
    @Label(value = "燃烧物质")
    private String burningMaterial;
    
    @Label(value = "火势情况")
    private String fireSituation;
    
    @Label(value = "危险爆炸品")
    private String dangerousExplosives;
    /**
     * 航空器救援
     */
    @ApiModelProperty(value = " 警情特有属性拼接")
    private String content;
    @ApiModelProperty(value = "联系人姓名")
    private String contactUser;

    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    @ApiModelProperty(value = "调派单位资源列表")
    private String company;

    @ApiModelProperty(value = "调派类型队伍")
    private String powerTransType;
}
