package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author litw
 * @date 2021-10-12.
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="OrgUsrSafeReportDto", description="机场单位消防安全报告")
public class OrgUsrSafeReportExcelDto extends BaseDto {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "报告名称", index = 0)
    @ApiModelProperty(value = "报告名称")
    private String name;

    @ExcelProperty(value = "报告类型", index = 1)
    @ApiModelProperty(value = "报告类型")
    private String type;

    @ExcelIgnore
    @ApiModelProperty(value = "报告类型code")
    private String typeCode;

    @ExcelProperty(value = "生效年份", index = 2)
    @ApiModelProperty(value = "生效年份")
    private Date takeEffectYear;

    @ExcelProperty(value = "签订时间", index = 3)
    @ApiModelProperty(value = "签订时间")
    private Date signedDate;

    @ExcelIgnore
    @ApiModelProperty(value = "机构代码用于权限过滤")
    private String orgCode;

    @ExplicitConstraint(method = "getCompany", indexNum = 4, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "所属机场单位名称", index = 4)
    @ApiModelProperty(value = "所属机场单位名称")
    private String company;

    @ExcelIgnore
    @ApiModelProperty(value = "所属机场单位id")
    private Long companyId;

    @ExcelIgnore
    @ApiModelProperty(value = "单位类型（1机场单位，0机场部门）")
    private String companyType;

    @ExcelProperty(value = "责任人", index = 5)
    @ApiModelProperty(value = "责任人")
    private String dutyPerson;

    @ExcelIgnore
    @ApiModelProperty(value = "责任人Id")
    private String dutyPersonId;

}
