package com.yeejoin.amos.maintenance.dao.entity;

import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Date;

/**
 * The persistent class for the p_point database table.
 * 
 */
@XmlRootElement
@Entity
@Table(name="p_point_config")
@NamedQuery(name="PointConfig.findAll", query="SELECT pc FROM PointConfig pc")
@Where(clause="is_delete=0")//表示未删除的数据
public class PointConfig extends BasicEntity{
	private static final long serialVersionUID = 1L;
	
	/**
	 * 转发名称
	 */
	@XmlElement
	@Column(name="name")
	private String name;
	
	/**
	 * 巡检点编号
	 */
	@XmlElement
	@Column(name="point_id")
	private long pointId;
	/**
	 * 0:正常和漏检状态，1：合格不合格状态
	 */
	@XmlElement
	@Column(name="point_code")
	private int pointCode;
	/**
	 * 转发信息地址依次递增（唯一）
	 */
	@XmlElement
	@Column(name="infomation_address")
	private int infomationAddress;
	/**
	 * 巡检点状态（code=0时，status=1漏检，status=0正常；code=1时，status=1不合格，status=0合格）
	 */
	@XmlElement
	@Column(name="status")
	private boolean status;
	/**
	 * 更新时间
	 */
	@XmlElement
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="update_date")
	private Date updateDate;
	/**
	 * 是否已经删除
	 */
	@XmlElement
	@Column(name="is_delete")
	private boolean isDelete;
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public long getPointId() {
		return pointId;
	}
	public void setPointId(long pointId) {
		this.pointId = pointId;
	}
	public int getPointCode() {
		return pointCode;
	}
	public void setPointCode(int pointCode) {
		this.pointCode = pointCode;
	}
	public int getInfomationAddress() {
		return infomationAddress;
	}
	public void setInfomationAddress(int infomationAddress) {
		this.infomationAddress = infomationAddress;
	}
	public boolean isStatus() {
		return status;
	}
	public void setStatus(boolean status) {
		this.status = status;
	}
	public Date getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	public boolean isDelete() {
		return isDelete;
	}
	public void setDelete(boolean isDelete) {
		this.isDelete = isDelete;
	}
	
	
}
