package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 人员保险信息附件
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_person_insurance_attachment")
@ApiModel(value = "PersonInsuranceAttachment对象", description = "人员保险信息附件")
public class PersonInsuranceAttachment extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "人员保险信息id")
    private Long personInsuranceId;
    @ApiModelProperty(value = "附件地址")
    @ImagePrefix
    private String attachment;
}
