package com.yeejoin.precontrol.common.enums;

public enum PersonActiveStatusEnum {

	NO_ACTIVE(0, "离场"),

	ACTIVE(1, "在场");

	private int type;

	private String name;

	PersonActiveStatusEnum(int type, String name) {
		this.type = type;
		this.name = name;
	}

	public int getType() {
		return type;
	}

	public String getName() {
		return name;
	}

	public static String getNameByType(int type) {
		String name = null;
		for (PersonActiveStatusEnum enumOne : PersonActiveStatusEnum.values()) {
			if (enumOne.getType() == type) {
				name = enumOne.getName();
				break;
			}
		}
		return name;
	}
}
