package com.yeejoin.precontrol.common.publish;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.precontrol.common.listener.event.TranslateEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: duanwei
 * @date: 2020-08-05 15:22
 **/
@Component
public class TranslateEventPublish extends AbstractEventPublish {

    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void publish(String message) {
        TranslateEvent translateEvent = new TranslateEvent(this, message);
        applicationEventPublisher.publishEvent(translateEvent);
    }

    public void publish(JSONObject message) {
        TranslateEvent translateEvent = new TranslateEvent(this, message);
        applicationEventPublisher.publishEvent(translateEvent);
    }


    public void publish(Object object) {
        TranslateEvent translateEvent = new TranslateEvent(this, object);
        applicationEventPublisher.publishEvent(translateEvent);
    }


}
