package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.precontrol.common.entity.VideoBlock;
import com.yeejoin.precontrol.common.vo.VideoBlockVo;

/**
 * @Author: songLei
 * @Description:
 * @Date: 2021/10/15 10:05
 * @Version: 1.0
 */
public interface IVideoBlockService extends IService<VideoBlock> {
    /**
     * @Description 记录用户浏览
     * @param model
     * @Return Boolean
     * @Date 2021/10/15 15:05
     */
    Boolean browseVideo(AgencyUserModel model);
    
    Boolean browseVideo(Long personId);
    /**
     * @Description 离开浏览
     * @param model
     * @Return Boolean
     * @Date 2021/10/15 15:28
     */
    Boolean leaveBrowse(AgencyUserModel model);
    
    Boolean leaveBrowse(Long personId);
    /**
     * @Description 分页查询
     * @param page,videoBlock
     * @Return Boolean
     * @Date 2021/10/15 15:28
     */
    IPage<VideoBlockVo> getPage(Page page, VideoBlockVo vo);
}
