package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.yeejoin.precontrol.common.entity.PersonMessage;
import com.yeejoin.precontrol.common.entity.TaskRiskControl;
import com.yeejoin.precontrol.common.enums.MessageSubTypeEnum;
import com.yeejoin.precontrol.common.enums.MessageTypeEnum;
import com.yeejoin.precontrol.common.mapper.PersonMessageMapper;
import com.yeejoin.precontrol.common.service.IPersonMessageService;
import com.yeejoin.precontrol.common.service.ITaskRiskControlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author duanwei
 * @date 2020-06-30
 */
@Service
public class PersonMessageServiceImpl extends ServiceImpl<PersonMessageMapper, PersonMessage> implements IPersonMessageService {

    @Autowired
    ITaskRiskControlService taskRiskControlService;

    @Override
    public Page messagePageList(Integer pageNumber, Integer pageSize, Long personId, Integer type) {
        Page page = new Page();
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        Page<PersonMessage> personMessagePage = this.baseMapper.queryMessagePageList(page, personId, type);
        List<PersonMessage> personMessageList = personMessagePage.getRecords();

        // 如果是风险作业类型，获取最新的stage
        List<PersonMessage> taskRiskPersonMessageList =
                personMessageList.stream().filter(i -> MessageTypeEnum.RISK_WORK.getType() == i.getType()).collect(Collectors.toList());
        List<TaskRiskControl> taskRiskControlList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(taskRiskPersonMessageList)) {
            taskRiskControlList =
                    taskRiskControlService.list(new LambdaQueryWrapper<TaskRiskControl>().in(TaskRiskControl::getId,
                            Lists.transform(taskRiskPersonMessageList, PersonMessage::getId)));
        }
        List<TaskRiskControl> finalTaskRiskControlList = taskRiskControlList;

        personMessagePage.getRecords().forEach(r -> {
            r.setTypeName(MessageTypeEnum.getNameByType(r.getType()));
            if (r.getSubType() != null) {
                r.setSubTypeName(MessageSubTypeEnum.getNameByType(r.getSubType().intValue()));
                r.setStatus(MessageSubTypeEnum.getStatusByType(r.getSubType().intValue()));
            }

            // 如果是风险作业类型，获取最新的stage
            if (MessageTypeEnum.RISK_WORK.getType() == r.getType()) {
                finalTaskRiskControlList.stream().filter(i -> i.getId().equals(r.getTaskId())).findFirst()
                        .ifPresent(taskRiskControl -> r.setParam(taskRiskControl.getStage().toString()));
            }
        });
        return personMessagePage;
    }
}
