package com.yeejoin.precontrol.common.utils;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.precontrol.common.entity.Districts;
import com.yeejoin.precontrol.common.service.impl.DistrictsServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class DistrictsUtils {


    /**
     * 传递文本和深度进行查询
     *
     * @param text
     * @return
     */
    public static String findByName(String text) {
        DistrictsServiceImpl districtsService = SpringUtils.getBean(DistrictsServiceImpl.class);
        if (StringUtils.isNotEmpty(text)) {
            //切割省市区中文
            String[] splitText = text.split(",");
            if (splitText.length == 3) {
                String province = splitText[0];
                String city = splitText[1];
                String area = splitText[2];
                String returnValue = "";
                try {
                    Districts provinceResult =
                            districtsService.getOne(new QueryWrapper<Districts>().eq("ext_name", province).eq("deep",
                                    "0"));
                    Districts cityResult =
                            districtsService.getOne(new QueryWrapper<Districts>().eq("ext_name", city).eq("deep",
                                    "1"));
                    List<Districts> areaResult =
                            districtsService.list(new QueryWrapper<Districts>().eq("ext_name", area));

                    if (provinceResult != null && cityResult != null) {
                        returnValue += provinceResult.getId() + "," + cityResult.getId();
                        if (StringUtil.isNotEmpty(areaResult)) {
                            returnValue += "," + areaResult.get(0).getId();
                        }
                        return returnValue;
                    } else {
                        return null;
                    }
                } catch (Exception e) {
                    return null;
                }
            } else {
                return null;
            }
        } else {
            return null;
        }
    }

}
