package com.yeejoin.precontrol.common.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.annotations.TableFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class PersonStatisticVo {

    private Long id;
    @Excel(name = "姓名")
    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "性别( 0-男 1-女 )")
    private Integer sex;
    @TableField(exist = false)
    private String sexLabel;//

    @ApiModelProperty(value = "生日")
    private Date birthday;
    @ApiModelProperty(value = "年龄")
    private Integer age;
    @ApiModelProperty(value = "名族")
    private String folkKey;
    @ApiModelProperty(value = "身高")
    private Integer height;
    @ApiModelProperty(value = "体重")
    private Integer weight;
    @ApiModelProperty(value = "电话")
    private String phone;
    @ApiModelProperty(value = "应急电话")
    private String emergencyPhone;
    @ApiModelProperty(value = "政治面貌")
    private String politicCountenance;
    @ApiModelProperty(value = "证件编号")
    @TableField("ID_number")
    private String idNumber;
    @ApiModelProperty(value = "证件类型")

    @TableField("ID_type")
    private Integer idType;
    @TableField(exist = false)
    private String idTypeLabel;

    @ApiModelProperty(value = "籍贯")
    private String nativePlace;
    @TableField(exist = false)
    private String nativePlaceLabel;

    @ApiModelProperty(value = "用工来源所在地")
    private String employPlace;
    @TableField(exist = false)
    private String employPlaceLabel;

    @ApiModelProperty(value = "地址")
    private String address;
    @ApiModelProperty(value = "现住址")
    private String presentAddress;
    @ApiModelProperty(value = "参加工作时间")
    private Date workTime;
    @ApiModelProperty(value = "头像照片")
    @ImagePrefix
    private String headPhoto;
    @ApiModelProperty(value = "证件照片正面")
    @ImagePrefix
    private String frontCertificatePhoto;
    @ApiModelProperty(value = "证件照片反面")
    @ImagePrefix
    private String backCertificatePhoto;
    @ApiModelProperty(value = "考核成绩")
    private Integer examineScore;
    @ApiModelProperty(value = "是否合格")
    private Boolean qualified;
    @ApiModelProperty(value = "综合评分")
    private Float compositeScore;
    @ApiModelProperty(value = "是否可用")
    private Integer isEnabled;
    @ApiModelProperty(value = "平台账号sequenceNbr")
    private String accountNumber;
    @ApiModelProperty(value = "平台账号名称")
    private String accountName;
    @ApiModelProperty(value = "平台账号角色")
    private String accountRoleName;

    @ApiModelProperty(value = "入离岗状态")
    private String status;
    private String inOutStatusName;

    @TableFormat(entityName = "rpm_company", fieldName = "name", operFieldName = "companyName")
    private Long companyId;
    @Excel(name = "分包商")
    private String companyName;

    @TableFormat(entityName = "rpm_project", fieldName = "name", operFieldName = "projectName")
    private Long projectId;
    @Excel(name = "所属项目")
    private String projectName;

    @Excel(name = "地区")
    private String region;

    @ApiModelProperty(value = "二维码颜色")
    private Long color;
    @Excel(name = "安全态势")
    private String colorName;

    @ApiModelProperty(value = "岗位名称")
    private String postName;

    private Date createDate;
}
