package com.yeejoin.amos.boot.module.ccs.biz.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireBuildingDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireBuildingServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 消防建筑表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "消防建筑表Api")
@RequestMapping(value = "/fire-building")
public class FireBuildingController extends BaseController {

    @Autowired
    FireBuildingServiceImpl fireBuildingServiceImpl;


    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{stationCode}/page")
    @ApiOperation(httpMethod = "GET", value = "消防建筑表分页查询", notes = "消防建筑表分页查询")
    public ResponseModel<Page<FireBuildingDto>> queryForPage(
            @ApiParam(value = "建筑名称") @RequestParam(value = "name", required = false) String name,
            @ApiParam(value = "当前页", required = true) @RequestParam(value = "current") int current,
            @ApiParam(value = "页大小", required = true) @RequestParam(value = "size") int size,
            @ApiParam(value = "建筑类型") @RequestParam(value = "buildingType") String buildingType,
            @ApiParam(value = "换流站code", required = true) @PathVariable String stationCode) {
        Page<FireBuildingDto> page = new Page<FireBuildingDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireBuildingServiceImpl.queryForFireBuildingPage(page, name, stationCode, buildingType));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{stationCode}/tree")
    @ApiOperation(httpMethod = "GET", value = "指定换流站的消防建筑树", notes = "指定换流站的消防建筑树")
    public ResponseModel buildingTree(
            @ApiParam(value = "换流站code") @PathVariable String stationCode) {
        return ResponseHelper.buildResponse(fireBuildingServiceImpl.buildingTree(stationCode));
    }
    
    /**
     * 
     * @param mrid
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{mrid}/info")
    @ApiOperation(httpMethod = "GET", value = "根据建筑编码获取建筑信息", notes = "根据建筑编码获取建筑信息")
    public ResponseModel getBuildingByMrid(
            @ApiParam(value = "建筑code") @PathVariable String mrid) {
        return ResponseHelper.buildResponse(fireBuildingServiceImpl.getBuildingByMrid(mrid));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "stationBuildingTree")
    @ApiOperation(httpMethod = "GET", value = "换流站建筑树", notes = "换流站建筑树")
    public ResponseModel stationBuildingTree (@ApiParam(value = "换流站code")
             @RequestParam(value = "stationCode", required = false) String stationCode) {
        return ResponseHelper.buildResponse(fireBuildingServiceImpl.stationBuildingTree(stationCode));
    }
}
