package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.utils.CommonPageable;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.mapper.CarMapper;
import com.yeejoin.equipmanage.service.ICarService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: CarStatisticController
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2024/7/26 15:17
 */
@RestController
@Api(tags = "消防车统计Api")
@RequestMapping(value = "/center/car", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Slf4j
public class CarStatisticController extends AbstractBaseController {

    @Autowired
    @Lazy
    ICarService iCarService;

    @Autowired
    CarMapper carMapper;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/used/info", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取车辆归属权统计信息", notes = "获取车辆归属权统计信息")
    public List<Map<String, Object>> getCarUsedInfo(@RequestParam(required = false) String bizOrgCode) {
        return iCarService.getCarUsedInfo(bizOrgCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/type/info", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取车辆装备类别统计信息", notes = "获取车辆装备类别统计信息")
    public List<Map<String, Object>> getCarTypeInfo(@RequestParam(required = false) String bizOrgCode) {
        return iCarService.getCarTypeInfo(bizOrgCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/statistic", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取车辆分类统计信息", notes = "获取车辆分类统计信息")
    public List<Map<String, Object>> getCarInfo(@RequestParam(required = false) String bizOrgCode) {
        return iCarService.getCarTypeStatistic(bizOrgCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取车辆分页", notes = "获取车辆分页")
    public ResponseModel getCarInfoPage(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode,
                                      @RequestParam(required = false) String sorter) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        String sortField = "", sortOrder = "";
        if (org.springframework.util.StringUtils.hasText(sorter)) {
            sortField = sorter.split("@")[0];
            sortOrder = sorter.split("@")[1];
        }
        Page<Map<String, Object>> page1 = carMapper.getCarInfoPage(page, bizOrgCode, sortField, sortOrder);
        return CommonResponseUtil.success(page1);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/station/page", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取车辆分页", notes = "获取车辆分页")
    public ResponseModel getStationCarInfoPage(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        Page<Map<String, Object>> page1 = carMapper.getStationCarInfoPage(page, bizOrgCode);
        return CommonResponseUtil.success(page1);
    }
}
