package com.yeejoin.equipmanage.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.equipmanage.remote.RemoteSecurityService;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;

/**
 * @author DELL
 */
@RestController
@RequestMapping("/api/common")
@Api("通用接口")
@Slf4j
public class CommonController extends AbstractBaseController {

    @Autowired
    RemoteSecurityService remoteSecurityService;
	@TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping("/deptTree")
    public List<DepartmentModel> getDeptTree(){
        ReginParams reginParams = getSelectedOrgInfo();
        Long companyId = Long.valueOf(getCompanyId(reginParams));
        if(log.isInfoEnabled()){
            log.info("公司信息:{}",companyId);
        }
        return remoteSecurityService.getDepartmentTreeByCompanyId(companyId);
    }
}
