package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.MaintainWithinSevenDays;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.service.IMaintainWithinSevenDaysService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "七天保养Api")
@RequestMapping(value = "/maintain-within-seven-days", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class MaintainWithinSevenDaysController {

  @Autowired
  IMaintainWithinSevenDaysService iMaintainWithinSevenDaysService;


    /**
    * 新增
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveMaintainWithinSevenDays(HttpServletRequest request, @RequestBody MaintainWithinSevenDays maintainWithinSevenDays){
    return iMaintainWithinSevenDaysService.save(maintainWithinSevenDays);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return iMaintainWithinSevenDaysService.removeById(id);
    }


    /**
    * 修改
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdMaintainWithinSevenDays(HttpServletRequest request, @RequestBody MaintainWithinSevenDays maintainWithinSevenDays){
    return iMaintainWithinSevenDaysService.updateById(maintainWithinSevenDays);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
       @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public MaintainWithinSevenDays selectById(HttpServletRequest request, @PathVariable Long id){
      return iMaintainWithinSevenDaysService.getById(id);
   }



  /**
  * 列表分页查询
  * @return
  */
  @RequestMapping(value = "/list", method = RequestMethod.GET)
      @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<MaintainWithinSevenDays> listPage(String pageNum,String pageSize,
    MaintainWithinSevenDays maintainWithinSevenDays){

    Page<MaintainWithinSevenDays> pageBean;
    QueryWrapper<MaintainWithinSevenDays> maintainWithinSevenDaysQueryWrapper = new QueryWrapper<>();
    Class<? extends MaintainWithinSevenDays> aClass = maintainWithinSevenDays.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            ReflectionUtils.makeAccessible(field);
            Object o = field.get(maintainWithinSevenDays);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(maintainWithinSevenDays);
                maintainWithinSevenDaysQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(maintainWithinSevenDays);
                maintainWithinSevenDaysQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(maintainWithinSevenDays);
                maintainWithinSevenDaysQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(maintainWithinSevenDays);
                maintainWithinSevenDaysQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<MaintainWithinSevenDays> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iMaintainWithinSevenDaysService.page(pageBean, maintainWithinSevenDaysQueryWrapper);
    return page;
  }
}


