package com.yeejoin.equipmanage.operation.factory;

import com.yeejoin.equipmanage.common.enums.GroupTypeEnum;
import com.yeejoin.equipmanage.operation.PageOperation;
import com.yeejoin.equipmanage.operation.impl.BuildBuildingPage;
import com.yeejoin.equipmanage.operation.impl.BuildFloorPage;
import com.yeejoin.equipmanage.operation.impl.BuildRoomPage;
import com.yeejoin.equipmanage.operation.impl.RoomPage;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @Author: songLei
 * @Description: 分页工厂
 * @Date: 2020/12/23 10:41
 * @Version: 1.0
 */
public class PageOperatorFactory {
    static Map<String, PageOperation> operationMap = new HashMap<>();
    static {
        operationMap.put(GroupTypeEnum.ALLBUILDING.getType(), new BuildBuildingPage());
        operationMap.put(GroupTypeEnum.FLOOR.getType(), new BuildBuildingPage());
        operationMap.put(GroupTypeEnum.ROOM.getType(), new RoomPage());
        operationMap.put(GroupTypeEnum.BUILDING.getType(), new BuildRoomPage());
        operationMap.put(GroupTypeEnum.BUILDINGFLOOR.getType(), new BuildFloorPage());
    }
    public static Optional<PageOperation> getOperation(String operator) {
        return Optional.ofNullable(operationMap.get(operator));
    }
}
