package com.yeejoin.equipmanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.equipmanage.common.entity.FormGroupColumnEquip;
import com.yeejoin.equipmanage.common.enums.DataOption;
import com.yeejoin.equipmanage.mapper.FormGroupColumnEquipMapper;
import com.yeejoin.equipmanage.service.IFormGroupColumnEquipService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.component.cache.enumeration.CacheType;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
@Service
public class FormGroupColumnEquipServiceImpl extends ServiceImpl<FormGroupColumnEquipMapper, FormGroupColumnEquip> implements IFormGroupColumnEquipService {
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public List<FormGroupColumnEquip> queryByGroup(String groupCode) {
        QueryWrapper<FormGroupColumnEquip> wrapper = new QueryWrapper<>();
        wrapper.eq("group_code",groupCode);
        return this.baseMapper.selectList(wrapper);
    }

    @Override
    public Map<String, Map<String, Object>> processEnumData(String fieldName, String value) {
        Map<String, Map<String, Object>> returnMap = new HashMap<>();
        DataOption option = DataOption.getInstance(fieldName);
        if (!ValidationUtil.isEmpty(option)) {
            try {
                String cacheKey = Redis.genKey(CacheType.ERASABLE.name(), "ENUM_DICT_VALUE",option.name());
                List<DictionarieValueModel> valueModels = redisUtils.get(cacheKey) == null ? new ArrayList<>() : JSONObject.parseArray(redisUtils.get(cacheKey).toString(),DictionarieValueModel.class);
                if (ValidationUtil.isEmpty(valueModels)) {
                    valueModels = FeignUtil.remoteCall(() -> Systemctl.dictionarieClient.dictValues(option.name()));
                    redisUtils.set(cacheKey, JSONObject.toJSONString(valueModels),60*60*24);
                }
                if (!ValidationUtil.isEmpty(valueModels)) {
                    Map<String, Object> map = new HashMap<>();
                    Map dictValueMap = Bean.listToMap(valueModels, "dictDataKey", "dictDataValue", DictionarieValueModel.class);
                    String dictKeys[] = StringUtil.string2Array(value);
                    for (String dictKey : dictKeys){
                        map.put(dictKey, dictValueMap.get(dictKey));
                    }
                    returnMap.put(fieldName + "_dictValue", map);
                }
            } catch (Exception e) {
                log.error(e.getMessage(), e);
                throw new RuntimeException("枚举类型处理失败.");
            }
        }
        return returnMap;
    }
}
