package com.yeejoin.amos.knowledgebase.face.service;


import com.yeejoin.amos.knowledgebase.face.model.KnowledgeInteractionRecordModel;
import com.yeejoin.amos.knowledgebase.face.orm.dao.InteractionRecordMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeInteractionRecord;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;
import java.util.List;


/**
 * <p>
 * 知识库内容交互记录 服务类
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@Component
public class InteractionRecordService extends BaseService<KnowledgeInteractionRecordModel, KnowledgeInteractionRecord, InteractionRecordMapper> {


    public void createInteractionRecord(KnowledgeInteractionRecordModel interactionRecordModel) {
        interactionRecordModel.setRecDate(new Date());
        this.createWithModel(interactionRecordModel);
    }

    public void deleteInteractionRecord(KnowledgeInteractionRecordModel interactionRecordModel) {
        this.deleteBySeq(interactionRecordModel.getSequenceNbr());
    }


    public KnowledgeInteractionRecordModel queryUniqueModel(String userId, String entityType, String entityId, String operateType) {
        return this.queryModelByParams(userId, entityType, entityId, operateType);
    }

    /**
     * 获取用户对某类对象的操作记录列表
     *
     * @param userId      用户名
     * @param operateType 操作类型
     * @param entityType  操作对象
     * @param agencyCode
     * @return
     */
    public List<KnowledgeInteractionRecordModel> queryListByUser(String userId, String operateType, String entityType, String agencyCode) {
        return this.queryForList(null, false, userId, operateType, entityType, agencyCode);
    }

    /**
     * 某个对象被操作的数量统计
     *
     * @param operateType 操作类型
     * @param entityType  操作对象
     * @param entityId    对象Id
     * @return
     */
    public int countByInstance(String operateType, String entityType, String entityId) {
        return this.queryCount(operateType, entityType, entityId);
    }
}
