package com.yeejoin.amos.boot.module.tzs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 
 *
 * @author litw
 * @date 2021-09-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_elevator_status")
public class ElevatorStatus extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 电梯注册码
     */
	@TableField("register_code")
    private String registerCode;

    /**
     * 原始状态编号
     */
	@TableField("status_id")
    private String statusId;

    /**
     * 是否在线。1：是，0：否
     */
	@TableField("is_online")
    private Integer isOnline;

    /**
     * 运行数据上传时间
     */
	@TableField("upload_date")
    private Date uploadDate;

    /**
     * 总接触器吸合或是断开。0：吸合，1：断开
     */
	@TableField("main_contactor")
    private Integer mainContactor;

    /**
     * 运行接触器吸合或是断开。0：吸合，1：断开
     */
	@TableField("run_contactor")
    private Integer runContactor;

    /**
     * 安全回路是否断开，0：正常，1：断开
     */
	@TableField("circuit")
    private Integer circuit;

    /**
     * 当前电梯运行模式。1：停止服务 2：正常运行 3：检修 4：消防返回 5：消防员运行 6：应急电源运行 7：地震模式 8: 未知
     */
	@TableField("service_model")
    private Integer serviceModel;

    /**
     * 轿厢运行状态。1：停止，2：运行
     */
	@TableField("lift_status")
    private Integer liftStatus;

    /**
     * 轿厢运行方向。1：无方向 2：上行 3：下行
     */
	@TableField("lift_direction")
    private Integer liftDirection;

    /**
     * 轿厢是否在门区。1：轿厢在门区 0：轿厢在非门区
     */
	@TableField("is_zone")
    private Integer isZone;

    /**
     * 运行速度
     */
	@TableField("elevator_speed")
    private Integer elevatorSpeed;

    /**
     * 当前物理楼层
     */
	@TableField("curr_floor")
    private Integer currFloor;

    /**
     * 关门到位 1：关门到位，0：无关门到位信号
     */
	@TableField("door_status")
    private Integer doorStatus;

    /**
     * 上极限是否动作 0:否，1：是
     */
	@TableField("up_limit")
    private Integer upLimit;

    /**
     * 下极限是否动作 0:否，1：是
     */
	@TableField("down_limit")
    private Integer downLimit;

    /**
     * 轿厢报警按钮是否动作 0:否，1：是
     */
	@TableField("alarm")
    private Integer alarm;

    /**
     * 轿厢内是否有人 0：无，1：有
     */
	@TableField("person_flag")
    private Integer personFlag;

    /**
     * 累计运行小时数，保留到小数点后两位
     */
	@TableField("hours")
    private Double hours;

    /**
     * 累计运行次数
     */
	@TableField("run_count")
    private Integer runCount;

}
