package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import com.yeejoin.amos.boot.module.tzs.api.dto.RescueStationDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.RescueStation;
import com.yeejoin.amos.boot.module.tzs.api.mapper.RescueStationMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.IRescueStationService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Arrays;
import java.util.List;

/**
*  服务实现类
*
* @author tb
* @date 2021-06-01
*/
@Service
public class RescueStationServiceImpl extends BaseService<RescueStationDto, RescueStation, RescueStationMapper> implements IRescueStationService {

    @Autowired
    RescueStationMapper rescueStationMapper;

    @Override
    public List<RescueStationDto> getListByLatLonDistance(String lat, String lon, Integer distance) {
        return rescueStationMapper.getListByLatLonDistance(lat,lon,distance);
    }

    @Override
    public List<RescueStationDto> selectExportData(String exportId) {
        List<String> ids = null;
        if(StringUtils.isNotEmpty(exportId)) {
            String[] idStr = exportId.split(",");
            ids = Arrays.asList(idStr);
        }
        return baseMapper.selectExportData(ids);
    }
}
