package com.yeejoin.amos.boot.module.elevator.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 安全追溯-游乐设施
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="paramRides", description="游乐设施技术参数")
public class EquipTechParamRidesModel extends BaseDto {
    private static final long serialVersionUID = 1L;


            @ApiModelProperty(value = "")
        private String instanceId;
            @ApiModelProperty(value = "")
        private String status;
            @ApiModelProperty(value = "设计寿命")
        private Integer designLife;
            @ApiModelProperty(value = "滑道长度")
        private BigDecimal slideLength;
            @ApiModelProperty(value = "滑道高度")
        private BigDecimal slideHeight;
            @ApiModelProperty(value = "滑道最小坡度")
        private BigDecimal minimumSlopeOfSlide;
            @ApiModelProperty(value = "滑道平均坡度")
        private BigDecimal averageSlopeOfSlide;
            @ApiModelProperty(value = "滑道无跳跃段最大坡度")
        private BigDecimal maximumSlopeOfTheSlideWithoutJumping;
            @ApiModelProperty(value = "滑道最小曲率半径")
        private BigDecimal minimumRadiusOfCurvatureOfSlideway;
            @ApiModelProperty(value = "滑道数量")
        private Integer numberOfSlides;
            @ApiModelProperty(value = "滑道主体材料")
        private String mainMaterialOfSlide;
            @ApiModelProperty(value = "滑车数量")
        private Integer numberOfPulleys;
            @ApiModelProperty(value = "乘坐人数")
        private Integer numberOfPassengers;
            @ApiModelProperty(value = "水平距离")
        private BigDecimal horizontalDistance;
            @ApiModelProperty(value = "高度")
        private BigDecimal height;
            @ApiModelProperty(value = "下滑速度")
        private BigDecimal glideSpeed;
            @ApiModelProperty(value = "乘员数")
        private Integer countOfPassengers;
            @ApiModelProperty(value = "运行速度")
        private BigDecimal runningSpeed;
            @ApiModelProperty(value = "车辆数")
        private Integer numberOfVehicles;
            @ApiModelProperty(value = "功率")
        private BigDecimal power;
            @ApiModelProperty(value = "轨道高度")
        private BigDecimal trackHeight;
            @ApiModelProperty(value = "成员数")
        private Integer numberOfMembers;
            @ApiModelProperty(value = "运行高度")
        private BigDecimal operatingHeight;
            @ApiModelProperty(value = "驱动功率")
        private BigDecimal drivePower;
            @ApiModelProperty(value = "回转直径")
        private BigDecimal rotaryDiameter;
            @ApiModelProperty(value = "额定乘客数")
        private Integer ratedNumberOfPassengers;
            @ApiModelProperty(value = "吊舱数量")
        private Integer numberOfPods;
            @ApiModelProperty(value = "设备高度")
        private BigDecimal equipmentHeight;
            @ApiModelProperty(value = "额定线速度")
        private BigDecimal ratedLinearSpeed;
            @ApiModelProperty(value = "转盘转速")
        private BigDecimal rotaryTableSpeed;
            @ApiModelProperty(value = "单边摆角")
        private BigDecimal unilateralSwingAngle;
            @ApiModelProperty(value = "座舱数量")
        private Integer numberOfCabins;
            @ApiModelProperty(value = "最大运行高度")
        private BigDecimal maximumOperatingHeight;
            @ApiModelProperty(value = "旋转直径")
        private BigDecimal rotationDiameter;
            @ApiModelProperty(value = "最大转速")
        private BigDecimal maximumSpeed;
            @ApiModelProperty(value = "倾角")
        private BigDecimal dip;
            @ApiModelProperty(value = "回转速度")
        private BigDecimal slewingSpeed;
            @ApiModelProperty(value = "升降速度")
        private BigDecimal liftingSpeed;
            @ApiModelProperty(value = "高差")
        private BigDecimal heightDifference;
            @ApiModelProperty(value = "主索直径")
        private BigDecimal mainCableDiameter;
            @ApiModelProperty(value = "弦倾角")
        private BigDecimal angleOfChord;
            @ApiModelProperty(value = "乘客人数")
        private Integer passengerNum;
            @ApiModelProperty(value = "弹跳高度")
        private BigDecimal bounceHeight;
            @ApiModelProperty(value = "最大载重")
        private BigDecimal maximumLoad;
            @ApiModelProperty(value = "设备功率")
        private BigDecimal equipmentPower;
            @ApiModelProperty(value = "占地面积")
        private BigDecimal floorArea;
            @ApiModelProperty(value = "升空高度")
        private BigDecimal liftoffAltitude;
            @ApiModelProperty(value = "场地直径")
        private BigDecimal fieldDiameter;
            @ApiModelProperty(value = "球体直径")
        private BigDecimal sphereDiameter;
            @ApiModelProperty(value = "球体体积")
        private BigDecimal sphereVolume;
            @ApiModelProperty(value = "操作人数")
        private Integer operatorNumber;

    
}
