package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Getter
@AllArgsConstructor
/**
 * 使用登记审批完成后作废流程
 * 设备需要修改为未纳管类别
 */
public enum UseRegisterCancelEquipEnum {

    ldsqzj("流动式起重机", "4400"),
    jdgycl("机动工业车辆", "5100"),
    fglylyggcl("非公路用旅游观光车辆", "5200"),
    qp("气瓶", "2300");

    private final String name;

    private final String code;


    public static String getMessage(String code) {
        for (UseRegisterCancelEquipEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants.getName();
            }
        }
        return null;
    }

    public static List<String> getCodes() {
        List<String> codes = new ArrayList<>();
        for (UseRegisterCancelEquipEnum constants : values()) {
            codes.add(constants.getCode());
        }
        return codes;
    }




    public static Map<Integer,String> getName=new HashMap<>();
    public static Map<String,Integer> getCode=new HashMap<>();

    static {
        for (ConstructionEnum e : ConstructionEnum.values()){
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
