package com.yeejoin.amos.boot.module.jg.biz.handler.toBeSubmit;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.handler.strategy.ToBeSubmitDetailStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgReformNoticeServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import java.util.HashMap;
import java.util.Map;

@Component
public class ReformNoticeStrategyHandler implements ToBeSubmitDetailStrategy {

    @Lazy
    @Autowired
    private JgReformNoticeServiceImpl jgReformNoticeService;

    @Override
    public Map<String, Map<String, Object>> getDetails(Long sequenceNbr, ReginParams reginParams) {
        Map<String, Object> reformNotice = jgReformNoticeService.queryBySequenceNbr(sequenceNbr);

        Map<String, Object> basic = new HashMap<>();
        basic.put("type", ApplicationFormTypeEnum.GZGZ.getBusinessCode());
        basic.put("isTempEquip", true);
        basic.put("receiveOrgCreditCode", reformNotice.get("receiveOrgCode"));
        basic.put("code", reformNotice.get("EQU_LIST_CODE"));
        basic.put("equCategory", reformNotice.get("EQU_CATEGORY_CODE"));
        Map<String, Map<String, Object>> result = new HashMap<>();
        result.put("notice", reformNotice);
        result.put("basic", basic);
        return result;
    }

    @Override
    public String supportBusinessType() {
        return BusinessTypeEnum.JG_MODIFICATION_NOTIFICATION.getName();
    }
}
