package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.util.StringUtil;
import com.yeejoin.amos.boot.biz.common.annotation.ResultFieldMapping;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.common.api.enums.ConstructionTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.*;
import com.yeejoin.amos.boot.module.jg.api.service.IJgTransferNoticeService;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.TransferVo;
import com.yeejoin.amos.boot.module.jg.biz.config.LocalBadRequest;
import com.yeejoin.amos.boot.module.jg.biz.context.EquipUsedCheckStrategyContext;
import com.yeejoin.amos.boot.module.jg.biz.context.FlowingEquipRedisContext;
import com.yeejoin.amos.boot.module.jg.biz.edit.permission.FillingEditPermForCurrentUser;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.ICmWorkflowService;
import com.yeejoin.amos.boot.module.common.api.service.ICompensateFlowDataOfRedis;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgConstructionInfoService;
import com.yeejoin.amos.boot.module.jg.biz.utils.CodeUtil;
import com.yeejoin.amos.boot.module.jg.biz.utils.ObjectCleanerUtils;
import com.yeejoin.amos.boot.module.jg.biz.utils.WordTemplateUtils;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgConstructionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.RegistrationInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import io.seata.spring.annotation.GlobalTransactional;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgRegisterInfoServiceImpl.EQU_CATEGORY_CODE;
import static com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgRegisterInfoServiceImpl.EQU_LIST_CODE;

/**
 * 移装告知服务实现类
 *
 * @author system_generator
 * @date 2023-12-19
 */
@Service
public class JgTransferNoticeServiceImpl extends BaseService<JgTransferNoticeDto, JgTransferNotice, JgTransferNoticeMapper> implements IJgTransferNoticeService, ICompensateFlowDataOfRedis<JgTransferNotice> {

    private static final String SUBMIT_TYPE_FLOW = "1";
    private static final String SUBMIT_TYPE_TEMP = "3";
    private static final String PROCESS_DEFINITION_KEY = "transferNotice";
    private static final String TABLE_PAGE_ID = "transferNoticeAdd";
    private final List<String> NOT_FLOWING_STATE = Arrays.asList("6610", "6614", "6615", "6617", "6616");

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    JgTransferNoticeEqMapper jgTransferNoticeEqMapper;
    @Autowired
    RegistrationInfoMapper tzsJgRegistrationInfoMapper;
    @Autowired
    IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;
    @Autowired
    OtherInfoMapper tzsJgOtherInfoMapper;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    SupervisoryCodeInfoMapper supervisoryCodeInfoMapper;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    JgUseRegistrationMapper jgUseRegistrationMapper;
    @Autowired
    ICmWorkflowService iCmWorkflowService;
    @Autowired
    IdxBizJgUseInfoMapper idxBizJgUseInfoMapper;
    @Lazy
    @Autowired
    JgInstallationNoticeServiceImpl jgInstallationNoticeService;
    @Autowired
    private JgTransferNoticeMapper jgTransferNoticeMapper;
    @Autowired
    private CommonServiceImpl commonService;
    @Autowired
    private JgRegistrationHistoryMapper jgRegistrationHistoryMapper;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    ESEquipmentCategory esEquipmentCategory;
    @Autowired
    JgRegistrationHistoryServiceImpl jgRegistrationHistoryService;
    @Autowired
    JgTransferNoticeEqServiceImpl jgTransferNoticeEqService;

    @Autowired
    JgResumeInfoServiceImpl jgResumeInfoService;
    @Autowired
    JgVehicleInformationMapper jgVehicleInformationMapper;

    @Autowired
    private IIdxBizJgConstructionInfoService iIdxBizJgConstructionInfoService;

    @Autowired
    private CodeUtil codeUtil;

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return 移装告知
     */
    @Override
    @ResultFieldMapping({
            @ResultFieldMapping.ResultFieldMap(sourceField = "transferNoticeInfo.useUnitCreditCode", targetField = "transferNoticeInfo.useUnitSeq", serviceClass = CommonServiceImpl.class, queryMethod = "queryUnitInfoByCreditCode"),
    })
    public Map<String, Map<String, Object>> queryBySequenceNbr(Long sequenceNbr, CompanyBo companyBo) {
        // 移装告知信息
        JgTransferNotice notice = jgTransferNoticeMapper.selectById(sequenceNbr);
        if (Objects.isNull(notice)) {
            return null;
        }
        this.doCompensate(notice);
        Map<String, Object> transferNotice = BeanUtil.beanToMap(notice, false, true);
        transferNotice.put("province", notice.getProvince() + "_" + notice.getProvinceName());
        transferNotice.put("city", notice.getCity() + "_" + notice.getCityName());
        transferNotice.put("county", notice.getCounty() + "_" + notice.getCountyName());
        transferNotice.put("useUnitCreditCode", notice.getUseUnitCreditCode() + "_" + notice.getUseUnitName());
        transferNotice.put("receiveOrgCode", notice.getReceiveOrgCode() + "_" + notice.getReceiveOrgName());
        transferNotice.put("EQU_LIST_CODE", notice.getEquListCode());
        transferNotice.put("EQU_CATEGORY", notice.getEquCategory());
        transferNotice.put("QUERY_TYPE", "GZ_YZ");
        transferNotice.put("IS_INTO_MANAGEMENT", true);
        if (!ValidationUtil.isEmpty(notice.getFactoryUseSiteStreet()) && !ValidationUtil.isEmpty(notice.getStreetName())) {
            transferNotice.put("factoryUseSiteStreet", notice.getFactoryUseSiteStreet() + "_" + notice.getStreetName());
        }
        if (!ValidationUtil.isEmpty(notice.getConstructionManagerId()) && !ValidationUtil.isEmpty(notice.getConstructionManager())) {
            transferNotice.put("constructionManagerId", notice.getConstructionManagerId() + "_" + notice.getConstructionManager());
        }
        String[] fields = {"otherAccessories", "powerOfAttorney", "constructionContract"};
        // 设备信息
//        List<Map<String, Object>> equipmentInfos = jgTransferNoticeMapper.queryEquipInformation(sequenceNbr);
        List<JgTransferNoticeEq> jgTransferNoticeEqs = jgTransferNoticeEqMapper.selectList(new LambdaQueryWrapper<JgTransferNoticeEq>().eq(JgTransferNoticeEq::getEquipTransferId, sequenceNbr));
        List<String> ids = jgTransferNoticeEqs.stream().map(JgTransferNoticeEq::getEquId).collect(Collectors.toList());
        Iterable<ESEquipmentCategoryDto> allById = esEquipmentCategory.findAllById(ids);
        List<Map<String, Object>> equipListMaps = getEquipListMaps(allById);
        for (String s : fields) {
            if (transferNotice.containsKey(s)) {
                if ("powerOfAttorney".equalsIgnoreCase(s)) {
                    transferNotice.put("powerOfAttorneyList", ObjectUtils.isEmpty(transferNotice.get(s)) ? new JSONArray() : JSON.parseArray(transferNotice.get(s).toString()));
                } else if ("constructionContract".equalsIgnoreCase(s)) {
                    transferNotice.put("constructionContractList", ObjectUtils.isEmpty(transferNotice.get(s)) ? new JSONArray() : JSON.parseArray(transferNotice.get(s).toString()));
                } else if ("otherAccessories".equalsIgnoreCase(s)) {
                    transferNotice.put("otherAccessoriesList", ObjectUtils.isEmpty(transferNotice.get(s)) ? new JSONArray() : JSON.parseArray(transferNotice.get(s).toString()));
                } else {
                    transferNotice.put(s, ObjectUtils.isEmpty(transferNotice.get(s)) ? new JSONArray() : JSON.parseArray(transferNotice.get(s).toString()));
                }
            }
        }
        if (Integer.parseInt(notice.getNoticeStatus()) == FlowStatusEnum.TO_BE_FINISHED.getCode()) {
            // 完成时显示历史数据
            JSONObject hisData = commonService.queryHistoryData(notice.getSequenceNbr());
            // 兼容老数据
            if (hisData == null) {
                Map<String, Object> detail = getEquipInfoNew(companyBo, transferNotice, equipListMaps);
                new FillingEditPermForCurrentUser(new JSONObject(detail), companyBo, BusinessTypeEnum.JG_ADVICE_REMOVAL).getData();
                return new HashMap<String, Map<String, Object>>() {{
                    this.put("transferNoticeInfo", detail);
                }};
            } else {
                CommonServiceImpl.formatTime2StrDateForEquip(hisData);
                hisData.putAll(transferNotice);
                new FillingEditPermForCurrentUser(hisData, companyBo, BusinessTypeEnum.JG_ADVICE_REMOVAL).getData();
                return new HashMap<String, Map<String, Object>>() {{
                    this.put("transferNoticeInfo", hisData);
                }};
            }
        } else {
            // 显示最新的设备信息
            Map<String, Object> detail = getEquipInfoNew(companyBo, transferNotice, equipListMaps);
            detail.replaceAll((key, value) -> "null".equals(value) ? null : value);
            new FillingEditPermForCurrentUser(new JSONObject(detail), companyBo, BusinessTypeEnum.JG_ADVICE_REMOVAL).getData();
            return new HashMap<String, Map<String, Object>>() {{
                this.put("transferNoticeInfo", detail);
            }};
        }

    }

    private List<Map<String, Object>> getEquipListMaps(Iterable<ESEquipmentCategoryDto> equips) {
        List<Map<String, Object>> arrayList = new ArrayList<>();
        equips.forEach(equip -> {
            Map<String, Object> objectHashMap = new HashMap<>();
            BeanUtil.beanToMap(equip, objectHashMap, false, true);
            objectHashMap.put("record", equip.getSEQUENCE_NBR());
            objectHashMap.put("ADDRESS", concatDetailAddress(equip));
            arrayList.add(objectHashMap);
        });
        return arrayList;
    }

    private String concatDetailAddress(ESEquipmentCategoryDto esEquipmentCategoryDto) {
        // 省、市、区
        String usePlace = esEquipmentCategoryDto.getUSE_PLACE();
        // 详细地址
        String address = esEquipmentCategoryDto.getADDRESS();
        return String.format("%s%s", usePlace, address);
    }

    private void checkRepeatUsed(List<Map<String, Object>> deviceList, JgTransferNotice notice) {
        deviceList.forEach(obj -> EquipUsedCheckStrategyContext.getUsedStrategy(PROCESS_DEFINITION_KEY).equipRepeatUsedCheck(String.valueOf(obj.get("SEQUENCE_NBR")), notice.getInstallUnitCreditCode()));
    }

    private void repeatUsedEquipCheck(List<Map<String, Object>> equipList, String companyCode) {
        equipList.forEach(equipMap -> EquipUsedCheckStrategyContext.getUsedStrategy(PROCESS_DEFINITION_KEY).equipRepeatUsedCheck(String.valueOf(equipMap.get("SEQUENCE_NBR")), companyCode));
    }

    /**
     * 删除 redis校验重复引用设备的数据
     */
    private void delRepeatUseEquipData(JgTransferNotice notice) {
        if (NOT_FLOWING_STATE.contains(notice.getNoticeStatus())) {
            LambdaQueryWrapper<JgTransferNoticeEq> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(JgTransferNoticeEq::getEquipTransferId, notice.getSequenceNbr());
            List<JgTransferNoticeEq> jgTransferNoticeEqs = jgTransferNoticeEqMapper.selectList(queryWrapper);
            for (JgTransferNoticeEq noticeEq : jgTransferNoticeEqs) {
                EquipUsedCheckStrategyContext.getUsedStrategy(PROCESS_DEFINITION_KEY)
                        .delDataForCheckEquipRepeatUsed(Collections.singletonList(noticeEq.getEquId()), notice.getInstallUnitCreditCode());
            }
        }
    }

    private void rollBackForDelRedisData() {
        FlowingEquipRedisContext.getContext().forEach(e -> {
            EquipUsedCheckStrategyContext.getUsedStrategy(PROCESS_DEFINITION_KEY).delDataForCheckWithKey(e.getData(), e.getRedisKey());
        });
    }

    private Map<String, Object> getEquipInfoNew(CompanyBo companyBo, Map<String, Object> transferNotice, List<Map<String, Object>> equipmentInfos) {
//        Map<String, Object> detail = equipmentInfos.get(0);
//        Map<String, Object> equInfo = idxBizJgRegisterInfoService.getDetailFieldCamelCaseByRecord(detail.get("equId").toString());
//        equInfo.put("useUnitCreditCodeUse", equInfo.getOrDefault("useUnitCreditCode", ""));
//        equInfo.put("useUnitNameUse", equInfo.getOrDefault("useUnitName", ""));
//        equInfo.put("productPhoto", JSON.parse(String.valueOf(detail.get("productPhoto"))));
//        equInfo.put("factoryStandard", JSON.parse(String.valueOf(detail.get("factoryStandard"))));
//        equInfo.put("productQualityYieldProve", JSON.parse(String.valueOf(detail.get("productQualityYieldProve"))));
//        equInfo.put("insUseMaintainExplain", JSON.parse(String.valueOf(detail.get("insUseMaintainExplain"))));
//        equInfo.put("inspectReport", JSON.parse(String.valueOf(detail.get("inspectReport"))));
//        equInfo.put("designStandard", JSON.parse(String.valueOf(detail.get("designStandard"))));
//        equInfo.put("designDoc", JSON.parse(String.valueOf(detail.get("designDoc"))));
//        BeanUtil.copyProperties(equInfo, detail);
//        BeanUtil.copyProperties(transferNotice, detail, "equList", "supervisoryCode");
        transferNotice.put("companyLevel", CommonServiceImpl.getCompanyType(companyBo));
        transferNotice.put("deviceList", equipmentInfos);
        return transferNotice;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteForBatch(Long[] sequenceNbrs) {
        if (Objects.isNull(sequenceNbrs) || sequenceNbrs.length == 0) {
            return false;
        }
        for (Long sequenceNbr : sequenceNbrs) {
            // 删除待办 及 中止流程
            JgTransferNotice jgTransferNotice = this.getBaseMapper().selectById(sequenceNbr);
            commonService.deleteTaskModel(String.valueOf(sequenceNbr), jgTransferNotice.getInstanceId());
            // 删除业务单
            this.getBaseMapper().deleteById(sequenceNbr);
            // 删除对应eq
            jgTransferNoticeEqMapper.delete(new LambdaQueryWrapper<JgTransferNoticeEq>().eq(JgTransferNoticeEq::getEquipTransferId, sequenceNbr));
            // 删除单子对应历史表数据
            jgRegistrationHistoryMapper.delete(new LambdaQueryWrapper<JgRegistrationHistory>().eq(JgRegistrationHistory::getCurrentDocumentId, jgTransferNotice.getSequenceNbr()));
        }
        return Boolean.TRUE;
    }

    /**
     * 打印移装告知单
     *
     * @param sequenceNbr 主键
     * @return pdf文件路径
     */
    @Override
    public void generateTransferNoticeReport(Long sequenceNbr, HttpServletResponse response) {
        if (Objects.isNull(sequenceNbr)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        JgTransferNotice notice = this.getById(sequenceNbr);
        HashMap<String, Object> map = new HashMap<>();
        ArrayList<Map<String, Object>> maps = new ArrayList<>();
        List<Map<String, Object>> informationList = this.getBaseMapper().queryEquipInformation(notice.getSequenceNbr());
        if (CollectionUtils.isEmpty(informationList)) {
            throw new IllegalArgumentException("移装告知单不存在");
        }
        for (Map<String, Object> objectMap : informationList) {
            List<Map<String, Object>> temp = new ArrayList<>();
            objectMap.put("equipProvinceName", objectMap.get("provinceName"));
            objectMap.put("equipCityName", objectMap.get("cityName"));
            objectMap.put("equipCountyName", objectMap.get("countyName"));
            objectMap.put("equipStreetName", objectMap.get("streetName"));
            objectMap.put("equipAddress", objectMap.get("address"));
            temp.add(objectMap);
            Map<String, Object> placeholders = jgInstallationNoticeService.fullFillTemplateObj(temp, BusinessTypeEnum.JG_ADVICE_REMOVAL.getName().substring(0, 2));
            maps.add(placeholders);
        }
        String tempFileName = "移装告知单_" + System.currentTimeMillis() + "_temp";
        map.put("equipBasicInfoList", maps);
        WordTemplateUtils.templateToPdfDownload(tempFileName, "installation-notification-report.ftl", map, response);
    }

    /**
     * 更新移装告知
     *
     * @param noticeDto 移装告知
     */
    @SuppressWarnings({"rawtypes", "Duplicates"})
    @Transactional
    public JgTransferNoticeDto updateTransferNotice(String submitType, JgTransferNoticeDto noticeDto, String op) {
        try {
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            if (Objects.isNull(noticeDto) || StringUtils.isEmpty(submitType)) {
                throw new IllegalArgumentException("参数不能为空");
            }
            // 字段转换
            this.convertField(noticeDto);
            noticeDto.setPromoter(reginParams.getUserModel().getUserId());
            JgTransferNotice notice = this.getById(noticeDto.getSequenceNbr());
            // 获取告知设备列表
            List<Map<String, Object>> deviceList = noticeDto.getDeviceList();
            if (SUBMIT_TYPE_FLOW.equals(submitType)) {
                this.checkRepeatUsed(deviceList, notice);//校验设备是否在流程中
                if (!StringUtils.hasText(noticeDto.getInstanceId())) {
                    // 发起流程
                    ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
                    WorkflowResultDto workflowResultDto = new WorkflowResultDto();
                    // 如果没有实例ID，说明是启动并执行一步
                    // 直接调用工作流 启动并执行API  -  可以拿到两个节点的信息，用于填充业务字段
                    ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                    List<ActWorkflowStartDTO> list = new ArrayList<>();
                    ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                    dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
                    dto.setBusinessKey(String.valueOf(noticeDto.getSequenceNbr()));
                    dto.setCompleteFirstTask(Boolean.TRUE);
                    //下一节点执行人单位（下节点接收机构code）
                    dto.setNextExecuteUserCompanyCode(notice.getReceiveOrgCode());
                    list.add(dto);
                    actWorkflowBatchDTO.setProcess(list);
                    processTaskDTO = iCmWorkflowService.startBatch(actWorkflowBatchDTO).get(0);
                    // 提取节点等信息
                    workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
                    BeanUtils.copyProperties(noticeDto, notice);
                    if (!ObjectUtils.isEmpty(notice.getInstanceStatus())) {
                        notice.setInstanceStatus(notice.getInstanceStatus() + "," + workflowResultDto.getNextExecutorRoleIds());
                    } else {
                        notice.setInstanceStatus(workflowResultDto.getNextExecutorRoleIds());
                    }
                    notice.setPromoter(RequestContext.getExeUserId());
                    notice.setNextExecuteIds(String.join(",", workflowResultDto.getNextExecutorRoleIds()));
                    notice.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    notice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                    notice.setNextTaskId(workflowResultDto.getNextTaskId());
                    notice.setInstanceId(workflowResultDto.getInstanceId());
                    notice = ObjectCleanerUtils.removeStringNullFields(notice, JgTransferNotice.class);
                    jgTransferNoticeMapper.updateById(notice);
                    // 如果为保存并提交，则创建代办
                    buildTask(Collections.singletonList(notice), Collections.singletonList(workflowResultDto), Boolean.TRUE);
                } else {
                    ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
                    WorkflowResultDto workflowResultDto = new WorkflowResultDto();
                    // 只调用执行API，返回下个节点信息，用于填充业务字段
                    //组装信息
                    TaskResultDTO dto = new TaskResultDTO();
                    dto.setResultCode("approvalStatus");
                    dto.setTaskId(notice.getNextTaskId());
                    HashMap<String, Object> commMap = new HashMap<>();
                    if (notice.getNoticeStatus().equals("6614") || notice.getNoticeStatus().equals("6615")) {
                        commMap.put("approvalStatus", "提交");
                    } else {
                        commMap.put("approvalStatus", op);
                    }
                    dto.setVariable(commMap);
                    dto.setNextExecuteUserCompanyCode(notice.getReceiveOrgCode());
                    processTaskDTO = iCmWorkflowService.completeOrReject(notice.getNextTaskId(), dto, op);
                    // 提取节点等信息
                    workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
                    BeanUtils.copyProperties(noticeDto, notice);
                    if (!ObjectUtils.isEmpty(notice.getInstanceStatus())) {
                        notice.setInstanceStatus(notice.getInstanceStatus() + "," + workflowResultDto.getNextExecutorRoleIds());
                    } else {
                        notice.setInstanceStatus(workflowResultDto.getNextExecutorRoleIds());
                    }
                    notice.setPromoter(RequestContext.getExeUserId());
                    notice.setNextExecuteIds(String.join(",", workflowResultDto.getNextExecutorRoleIds()));
                    notice.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    notice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                    notice.setNextTaskId(workflowResultDto.getNextTaskId());
                    jgTransferNoticeMapper.updateById(notice);
                    // 上个代办改为已办
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("taskStatus", FlowStatusEnum.TO_BE_PROCESSED.getCode());
                    map.put("taskStatusLabel", FlowStatusEnum.TO_BE_PROCESSED.getName());
                    map.put("relationId", notice.getInstanceId());
                    map.put("flowStatus", FlowStatusEnum.TO_BE_PROCESSED.getCode());
                    map.put("flowStatusLabel", FlowStatusEnum.TO_BE_PROCESSED.getName());
                    TaskV2Model taskV2Model = commonService.updateTaskModel(map);
                    if (ObjectUtils.isEmpty(taskV2Model)) {
                        // 如果为保存并提交，则创建代办
                        buildTask(Collections.singletonList(notice), Collections.singletonList(workflowResultDto), Boolean.FALSE);
                    } else {
                        TaskModelDto taskModelDto = new TaskModelDto();
                        BeanUtils.copyProperties(taskV2Model, taskModelDto);
                        // 创建新的代办
                        taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                        taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                        taskModelDto.setFlowStatus(FlowStatusEnum.TO_BE_PROCESSED.getCode());
                        taskModelDto.setFlowStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                        taskModelDto.setFlowCode(notice.getNextTaskId());
                        taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                        TaskMessageDto taskMessageDto = new TaskMessageDto();
                        BeanUtils.copyProperties(notice, taskMessageDto);
                        taskModelDto.setModel(taskMessageDto);
                        commonService.buildTaskModel(Collections.singletonList(taskModelDto));
                    }
                }
                commonService.saveExecuteFlowData2Redis(notice.getInstanceId(), this.buildInstanceRuntimeData(notice));
            } else {
                JgTransferNotice bean = new JgTransferNotice();
                BeanUtils.copyProperties(noticeDto, bean);
                bean = ObjectCleanerUtils.removeStringNullFields(bean, JgTransferNotice.class);
                jgTransferNoticeMapper.updateById(bean);
            }

            jgTransferNoticeEqMapper.delete(new LambdaQueryWrapper<JgTransferNoticeEq>().eq(JgTransferNoticeEq::getEquipTransferId, noticeDto.getSequenceNbr().toString()));
            List<JgTransferNoticeEq> equipList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(deviceList)){
                deviceList.forEach(obj -> {
                    JgTransferNoticeEq jgRelationEquip = new JgTransferNoticeEq();
                    jgRelationEquip.setEquId(String.valueOf(obj.get("SEQUENCE_NBR")));
                    jgRelationEquip.setEquipTransferId(noticeDto.getSequenceNbr().toString());
                    equipList.add(jgRelationEquip);
                });
                jgTransferNoticeEqMapper.insertBatchSomeColumn(equipList);
            }
            return noticeDto;
        } catch (BadRequest | LocalBadRequest e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw new BadRequest("保存失败！");
        } finally {
            FlowingEquipRedisContext.clean();
        }
    }



    /**
     * 分页查询
     */
    @Override
    public Page<Map<String, Object>> queryForJgTransferNoticePage(Page<JgTransferNotice> page, String sort, JgTransferNoticeDto model, String type, ReginParams reginParams, String client) {

        String companyCode = reginParams.getCompany().getCompanyCode();
        SortVo sortMap = commonService.sortFieldConversion(sort);
        model.setTransferToUserIds(reginParams.getUserModel().getUserId());
        type = "jgLook".equals(client) ? null : type;
        String orgCode = "jgLook".equals(client) ? reginParams.getCompany().getOrgCode() : null;
        Page<Map<String, Object>> noticePage = jgTransferNoticeMapper.queryForPage(page, sortMap, model, type, companyCode,orgCode);
        List<Map<String, Object>> mappedRecords = noticePage.getRecords().stream().peek(notice -> {
            Optional<Long> noticeStatusOpt = Optional.ofNullable((String) notice.get("noticeStatus")).map(Long::valueOf);
            noticeStatusOpt.ifPresent(status -> {
                String noticeStatusDesc = FlowStatusEnum.getNameByType(Long.valueOf((String) notice.get("noticeStatus")));
                notice.put("noticeStatusDesc", noticeStatusDesc);
            });
        }).collect(Collectors.toList());

        noticePage.setRecords(mappedRecords);
        return noticePage;
    }
    /**
     * 列表查询-导出用
     */
    public List<TransferVo> queryTransferInIds(List<String> ids) {
        List<TransferVo> transferVos = jgTransferNoticeMapper.queryTransferInIds(ids);
        return transferVos.stream().peek(notice -> Optional.ofNullable(notice.getNoticeStatus()).ifPresent(status -> notice.setNoticeStatus(FlowStatusEnum.getNameByType(Long.valueOf(status))))).collect(Collectors.toList());
    }

    @Override
    @SuppressWarnings({"Duplicates", "rawtypes"})
    @Transactional(rollbackFor = Exception.class)
    public List<JgTransferNotice> saveNotice(String submitType, Map<String, Object> jgTransferNoticeDtoMap, ReginParams reginParams) {
        try {
            JgTransferNoticeDto model = JSON.parseObject(JSONObject.toJSONString(jgTransferNoticeDtoMap.get(TABLE_PAGE_ID)), JgTransferNoticeDto.class);
            Map<String, Object> tableData = (Map<String, Object>) jgTransferNoticeDtoMap.get(TABLE_PAGE_ID);
            model.setEquListCode(Objects.toString(tableData.get(EQU_LIST_CODE),""));
            model.setEquCategory(Objects.toString(tableData.get(EQU_CATEGORY_CODE),""));
            // 字段转换
            convertField(model);
            // 获取告知设备列表
            List<Map<String, Object>> deviceList = model.getDeviceList();
            // 提交时对设备状态进行校验（处理并发问题，一个未被使用的设备同时被多个使用这打开，同时提交发起申请）
            if (SUBMIT_TYPE_FLOW.equals(submitType)) {
                if (CollectionUtils.isEmpty(deviceList)) {
                    throw new BadRequest("请选择设备");
                }
                this.repeatUsedEquipCheck(deviceList, reginParams.getCompany().getCompanyCode());
            }
            List<String> applyNoList = new ArrayList<>();
            if (ValidationUtil.isEmpty(model.getApplyNo())){
                // 获取告知单号
                ResponseModel<List<String>> responseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.YZGZ.getCode(), 1);
                if (CollectionUtils.isEmpty(responseModel.getResult())) {
                    return new ArrayList<>();
                }
                applyNoList = responseModel.getResult();
            }else{
                applyNoList.add(model.getApplyNo());
            }

            // 启动工作流并返回信息
            List<WorkflowResultDto> workflowResultList = this.workFlowInfo(submitType, model.getReceiveCompanyCode());
            List<JgTransferNotice> list = new ArrayList<>();
            List<JgTransferNoticeEq> equipList = new ArrayList<>();
            //业务数据组装等
            businessData(submitType, reginParams, model, deviceList, applyNoList, workflowResultList, list, equipList);
            // 如果为保存并提交，则创建代办
            if (SUBMIT_TYPE_FLOW.equals(submitType)) {
                buildTask(list, workflowResultList, Boolean.TRUE);
            } else {
                // 暂存任务
                buildTaskDraft(list);
            }
            this.updateRedisBatch(list);
            return list;
        } catch (BadRequest | LocalBadRequest e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw new BadRequest("保存失败！");
        } finally {
            FlowingEquipRedisContext.clean();
        }
    }

    private void updateRedisBatch(List<JgTransferNotice> jgTransferNotices) {
        jgTransferNotices.stream().filter(n -> StringUtil.isNotEmpty(n.getInstanceId())).forEach(jgTransferNotice -> {
            commonService.saveExecuteFlowData2Redis(jgTransferNotice.getInstanceId(), this.buildInstanceRuntimeData(jgTransferNotice));
        });
    }

    /**
     * 暂存任务生成待办
     *
     * @param list 业务信息
     */
    private void buildTaskDraft(List<JgTransferNotice> list) {
        List<TaskModelDto> modelDtos = new ArrayList<>();
        list.forEach(obj -> {
            TaskModelDto dto = new TaskModelDto();
            //行数据
            TaskMessageDto taskMessageDto = new TaskMessageDto();
            BeanUtils.copyProperties(obj, taskMessageDto);
            dto.setModel(taskMessageDto);
            //摘要 按原有规则组装
            dto.setTaskContent(String.format("来自%s的业务办理，【申请单号：%s】", obj.getEquList(), obj.getApplyNo()));
            //申请单号
            dto.setTaskCode(obj.getApplyNo());
            //业务类型枚举code值
            dto.setTaskType(BusinessTypeEnum.JG_ADVICE_REMOVAL.getCode());
            ////业务主键
            dto.setRelationId(obj.getSequenceNbr() + "");
            modelDtos.add(dto);
        });
        commonService.buildTaskModel(modelDtos);
    }

    /**
     * 组装业务数据
     */
    private void businessData(String submitType, ReginParams reginParams, JgTransferNoticeDto model,
                              List<Map<String, Object>> deviceList, List<String> applyNoList,
                              List<WorkflowResultDto> workflowResultList, List<JgTransferNotice> list,
                              List<JgTransferNoticeEq> equipList) {
        CompanyBo companyBo = commonService.getOneCompany(model.getReceiveCompanyCode());
        JgTransferNotice dto = new JgTransferNotice();
        BeanUtils.copyProperties(model, dto);
        dto.setCreateUserCompanyName(reginParams.getCompany().getCompanyName());
        int i = 0;
        String applyNo = applyNoList.get(i);
        dto.setPromoter(reginParams.getUserModel().getUserId());
        dto.setApplyNo(applyNo);
        dto.setNoticeDate(new Date());
        // 统计用
        dto.setReceiveCompanyOrgCode(companyBo.getOrgCode());
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            dto.setNextExecuteIds(workflowResultList.get(i).getNextExecutorRoleIds());
            dto.setNextExecuteUserIds(workflowResultList.get(i).getNextExecutorUserIds());
            dto.setInstanceStatus(workflowResultList.get(i).getNextExecutorRoleIds() + "," + workflowResultList.get(i).getExecutorRoleIds());
            dto.setPromoter(reginParams.getUserModel().getUserId());
            dto.setNextTaskId(workflowResultList.get(i).getNextTaskId());
            dto.setIsTemporaryStatus("0");
        } else {
            dto.setNextExecuteUserIds(reginParams.getUserModel().getUserId());
        }
        if (SUBMIT_TYPE_TEMP.equals(submitType)){
            dto.setIsTemporaryStatus("1");
        }
        dto.setInstallUnitName(reginParams.getCompany().getCompanyName());
        dto.setInstallUnitCreditCode(reginParams.getCompany().getCompanyCode());
        if (!CollectionUtils.isEmpty(workflowResultList)) {
            dto.setInstanceId(workflowResultList.get(i).getInstanceId());
            dto.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
        } else {
            dto.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
        }
        dto.setCreateUserName(reginParams.getUserModel().getRealName());
        dto.setCreateUserId(reginParams.getUserModel().getUserId());
        dto.setCreateDate(new Date());
        dto.setEquList(jgVehicleInformationMapper.getEquCategoryNameByCode(model.getEquListCode()));
        dto.setEquCategory(jgVehicleInformationMapper.getEquCategoryNameByCode(model.getEquCategory()));
        dto = ObjectCleanerUtils.removeStringNullFields(dto, JgTransferNotice.class);
        list.add(dto);
        this.saveOrUpdate(list.get(0));
        if (!CollectionUtils.isEmpty(deviceList)){
            JgTransferNotice finalDto = dto;
            deviceList.forEach(obj -> {
                JgTransferNoticeEq jgRelationEquip = new JgTransferNoticeEq();
                jgRelationEquip.setEquId(String.valueOf(obj.get("SEQUENCE_NBR")));
                jgRelationEquip.setEquipTransferId(finalDto.getSequenceNbr() +"");
                jgRelationEquip.setEquCategory(obj.getOrDefault("EQU_CATEGORY", "").toString());//设备类别
                jgRelationEquip.setEquList(String.valueOf(obj.get("EQU_LIST")));//设备种类
                jgRelationEquip.setEquListCode(String.valueOf(obj.get("EQU_LIST_CODE")));//设备种类编码
                equipList.add(jgRelationEquip);
            });
            if (!ValidationUtil.isEmpty(model.getSequenceNbr())) {
                LambdaQueryWrapper<JgTransferNoticeEq> lambda = new QueryWrapper<JgTransferNoticeEq>().lambda();
                lambda.eq(JgTransferNoticeEq::getEquipTransferId, model.getSequenceNbr());
                jgTransferNoticeEqMapper.delete(lambda);
            }
            jgTransferNoticeEqMapper.insertBatchSomeColumn(equipList);
        }
    }


    /**
     * 插入代办
     */
    private void buildTask(List<JgTransferNotice> list, List<WorkflowResultDto> workflowResultList, Boolean isDeleteDraft) {
        List<TaskModelDto> taskModelDtoList = new ArrayList<>();
        WorkflowResultDto workflowResultDto = workflowResultList.get(0);
        list.forEach(item -> {
            TaskModelDto taskModelDto = new TaskModelDto();
            taskModelDto.setFlowCreateDate(item.getCreateDate());
            taskModelDto.setTaskName(workflowResultDto.getNextTaskName()); // 工作流API返回
            taskModelDto.setTaskCode(item.getApplyNo());
            taskModelDto.setTaskType(BusinessTypeEnum.JG_ADVICE_REMOVAL.getCode());
            taskModelDto.setTaskTypeLabel(BusinessTypeEnum.JG_ADVICE_REMOVAL.getName());
            taskModelDto.setRelationId(item.getInstanceId());
            taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds()); // 工作流API返回
            taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
            taskModelDto.setFlowStatus(commonService.getDictionaryCodeByName(FlowStatusEnum.TO_BE_PROCESSED.getName())); // 流程状态枚举
            taskModelDto.setFlowStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
            taskModelDto.setFlowCode(item.getNextTaskId());
            taskModelDto.setStartUserId(item.getCreateUserId());
            taskModelDto.setStartUser(item.getCreateUserName());
            taskModelDto.setStartUserCompanyName(item.getCreateUserCompanyName()); // 任务发起人所在单位
            taskModelDto.setStartDate(item.getCreateDate());
            taskModelDto.setNextExecuteUser(item.getNextExecuteIds());
            taskModelDto.setStartDate(new Date());
            taskModelDto.setTaskContent(String.format("来自%s的业务办理，【申请单号：%s】", item.getEquList(), item.getApplyNo()));
            TaskMessageDto taskMessageDto = new TaskMessageDto();
            BeanUtils.copyProperties(item, taskMessageDto);
            taskModelDto.setModel(taskMessageDto);
            taskModelDtoList.add(taskModelDto);
            if (isDeleteDraft) {
                // 删除暂存时生成的待办
                commonService.deleteTasksByRelationId(item.getSequenceNbr() + "");
            }
        });
        commonService.buildTaskModel(taskModelDtoList);
    }

    /**
     * 工作流启动并执行
     *
     * @param submitType 是否提交
     * @return 工作流返回相关数据
     */
    private List<WorkflowResultDto> workFlowInfo(String submitType, String receiveOrgCode) {
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
            List<ActWorkflowStartDTO> list = new ArrayList<>();
//            deviceList.forEach(item -> {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
            dto.setBusinessKey(String.valueOf(new Date().getTime()));
            dto.setCompleteFirstTask(Boolean.TRUE);
            //下一节点执行人单位（下节点接收机构code）
            dto.setNextExecuteUserCompanyCode(receiveOrgCode);
            list.add(dto);
//            });
            actWorkflowBatchDTO.setProcess(list);
            List<ProcessTaskDTO> processTaskDTOS = iCmWorkflowService.startBatch(actWorkflowBatchDTO);
            // 组装工作流返回的数据
            return commonService.buildWorkFlowInfo(processTaskDTOS);
        }
        return new ArrayList<>();
    }


    /**
     * 页面数据转换
     */
    private void convertField(JgTransferNoticeDto model) {
        // 处理图片
        if (!ValidationUtil.isEmpty(model.getConstructionContractList())) {
            model.setConstructionContract(JSON.toJSONString(model.getConstructionContractList()));
        }
        if (!ValidationUtil.isEmpty(model.getPowerOfAttorneyList())) {
            model.setPowerOfAttorney(JSON.toJSONString(model.getPowerOfAttorneyList()));
        }
        if (!ValidationUtil.isEmpty(model.getOtherAccessoriesList())) {
            model.setOtherAccessories(JSON.toJSONString(model.getOtherAccessoriesList()));
        } else {
            model.setOtherAccessories("");
        }
        // 分割省市区字段
        String province = model.getProvince();
        if (!ObjectUtils.isEmpty(province)) {
            String[] provinceList = province.split("_");
            if (provinceList.length > 1) {
                model.setProvince(provinceList[0]);
                model.setProvinceName(provinceList[1]);
            }
        }
        String city = model.getCity();
        if (!ObjectUtils.isEmpty(city)) {
            String[] cityList = city.split("_");
            if (cityList.length > 1) {
                model.setCity(cityList[0]);
                model.setCityName(cityList[1]);
            }
        }
        String county = model.getCounty();
        if (!ObjectUtils.isEmpty(county)) {
            String[] countyList = county.split("_");
            if (countyList.length > 1) {
                model.setCounty(countyList[0]);
                model.setCountyName(countyList[1]);
            }
        }
        // 分割单位
        String useUnitId = model.getUseUnitCreditCode();
        if (!ObjectUtils.isEmpty(useUnitId)) {
            String[] useUnitList = useUnitId.split("_");
            if (useUnitList.length > 1) {
                model.setUseUnitCreditCode(useUnitList[0]);
                model.setUseUnitName(useUnitList[1]);
            }
        }
        String receiveOrgId = model.getReceiveOrgCode();
        if (!ObjectUtils.isEmpty(receiveOrgId)) {
            String[] receiveOrgIdList = receiveOrgId.split("_");
            if (receiveOrgIdList.length > 1) {
                model.setReceiveOrgCode(receiveOrgIdList[0]);
                model.setReceiveCompanyCode(receiveOrgIdList[0]);
                model.setReceiveOrgName(receiveOrgIdList[1]);
            }
        }

        String constructionManagerId = model.getConstructionManagerId();
        if (!ObjectUtils.isEmpty(constructionManagerId)) {
            String[] constructionManagerIdList = constructionManagerId.split("_");
            if (constructionManagerIdList.length > 1) {
                model.setConstructionManagerId(constructionManagerIdList[0]);
                model.setConstructionManager(constructionManagerIdList[1]);
            }
        }

        String factoryUseSiteStreet = model.getFactoryUseSiteStreet();
        if (!ObjectUtils.isEmpty(factoryUseSiteStreet)) {
            String[] factoryUseSiteStreetList = factoryUseSiteStreet.split("_");
            if (factoryUseSiteStreetList.length > 1) {
                model.setFactoryUseSiteStreet(factoryUseSiteStreetList[0]);
                model.setStreetName(factoryUseSiteStreetList[1]);
            }
        }
    }


    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public void cancel(JgTransferNoticeDto noticeDto) {
        String instanceId = noticeDto.getInstanceId();
        String nextTaskId = noticeDto.getNextTaskId();
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForRevocationFlow(nextTaskId, instanceId);
            JgTransferNotice jgTransferNotice = this.baseMapper.selectById(noticeDto.getSequenceNbr());

            ProcessTaskDTO processTaskDTO = iCmWorkflowService.rollBack(jgTransferNotice.getInstanceId());
            // 提取节点等信息
            WorkflowResultDto workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
            jgTransferNotice.setPromoter("");
            jgTransferNotice.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
            jgTransferNotice.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
            jgTransferNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.ROLLBACK.getCode()));
            jgTransferNotice.setNextTaskId(workflowResultDto.getNextTaskId());
            jgTransferNoticeMapper.updateById(jgTransferNotice);
            TaskMessageDto taskMessageDto = new TaskMessageDto();
            BeanUtils.copyProperties(jgTransferNotice, taskMessageDto);
            JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(taskMessageDto));
            jsonObject.put("taskType", BusinessTypeEnum.JG_ADVICE_REMOVAL.getCode());
            jsonObject.put("nextExecuteUser", jgTransferNotice.getNextExecuteIds());
            jsonObject.put("flowStatusLabel", FlowStatusEnum.ROLLBACK.getName());
            jsonObject.put("flowStatus", FlowStatusEnum.ROLLBACK.getCode());
            jsonObject.put("nextTaskId", jgTransferNotice.getNextTaskId());
            commonService.rollbackTask(jgTransferNotice.getInstanceId(), jsonObject);
            commonService.saveExecuteFlowData2Redis(instanceId, this.buildInstanceRuntimeData(jgTransferNotice));
            this.delRepeatUseEquipData(jgTransferNotice);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }


    public InstanceRuntimeData buildInstanceRuntimeData(JgTransferNotice jgTransferNotice) {
        return InstanceRuntimeData.builder().nextExecuteUserIds(jgTransferNotice.getNextExecuteUserIds()).promoter(jgTransferNotice.getPromoter()).nextTaskId(jgTransferNotice.getNextTaskId()).build();
    }

    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public void accept(JgTransferNoticeDto dto, String op, String opinion) {
        String instanceId = dto.getInstanceId();
        String nextTaskId = dto.getNextTaskId();
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForExecuteFlow(nextTaskId, instanceId);
            JgTransferNotice jgTransferNotice = this.jgTransferNoticeMapper.selectById(dto.getSequenceNbr());

            // 检查实际状态是否不等于期望状态
            commonService.checkExpectedStatus(jgTransferNotice.getNoticeStatus());

            // 执行工作流并返回组装好的工作流信息
            WorkflowResultDto workflowResultDto = getWorkflowResultDto(op, opinion, jgTransferNotice);

            jgTransferNotice.setPromoter(RequestContext.getExeUserId());
            jgTransferNotice.setNextTaskId(workflowResultDto.getNextTaskId());
            TaskV2Model taskV2Model = new TaskV2Model();
            if ("0".equals(op)) {
                if (StringUtils.isEmpty(workflowResultDto.getNextExecutorRoleIds())) {
                    LambdaQueryWrapper<JgTransferNoticeEq> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(JgTransferNoticeEq::getEquipTransferId, dto.getSequenceNbr());
                    List<JgTransferNoticeEq> jgTransferNoticeEqs = jgTransferNoticeEqMapper.selectList(
                            new LambdaQueryWrapper<JgTransferNoticeEq>().eq(JgTransferNoticeEq::getEquipTransferId, jgTransferNotice.getSequenceNbr().toString()));

                    // 历史设备数据记录
                    this.saveHisDataBeforeUpdate(jgTransferNotice, jgTransferNoticeEqs);
                    this.updateEq(jgTransferNotice);
                    jgTransferNotice.setPromoter("");
                    jgTransferNotice.setHandleDate(new Date());
                    jgTransferNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
                    //修改设备ES设备使用场所和设备详细使用地址 ---- 移装告知不修改设备信息及es数据 BUG 21679
                    // Map<String, Map<String, Object>> objMap = new HashMap<>();
                    // for (JgTransferNoticeEq eq : jgTransferNoticeEqs) {
                    //     Map<String, Object> map1 = new HashMap<>();
                    //     map1.put("USE_PLACE", String.format("%s/%s/%s", jgTransferNotice.getProvinceName(), jgTransferNotice.getCityName(), jgTransferNotice.getCityName()));
                    //     map1.put("ADDRESS", String.format("%s/%s", jgTransferNotice.getStreetName(), jgTransferNotice.getAddress()));
                    //     objMap.put(eq.getEquId(), map1);
                    // }
                    // tzsServiceFeignClient.commonUpdateEsDataByIds(objMap);

                    // 修改使用信息 ---- 移装告知不修改设备信息及es数据 BUG 21679
                    // List<String> equIds = jgTransferNoticeEqs.stream().map(JgTransferNoticeEq::getEquId).collect(Collectors.toList());
                    // LambdaUpdateWrapper<IdxBizJgUseInfo> lambda = new LambdaUpdateWrapper<>();
                    // lambda.in(IdxBizJgUseInfo::getRecord, equIds);
                    // IdxBizJgUseInfo idxBizJgUseInfo = new IdxBizJgUseInfo();
                    // idxBizJgUseInfo.setProvince(jgTransferNotice.getProvince());
                    // idxBizJgUseInfo.setProvinceName(jgTransferNotice.getProvinceName());
                    // idxBizJgUseInfo.setCity(jgTransferNotice.getCity());
                    // idxBizJgUseInfo.setCityName(jgTransferNotice.getCityName());
                    // idxBizJgUseInfo.setCounty(jgTransferNotice.getCounty());
                    // idxBizJgUseInfo.setCountyName(jgTransferNotice.getCountyName());
                    // idxBizJgUseInfo.setFactoryUseSiteStreet(jgTransferNotice.getFactoryUseSiteStreet());
                    // idxBizJgUseInfo.setStreetName(jgTransferNotice.getStreetName());
                    // idxBizJgUseInfo.setAddress(jgTransferNotice.getAddress());
                    // idxBizJgUseInfo.setIsNotXiXian(jgTransferNotice.getIsXixian());
                    // idxBizJgUseInfoMapper.update(idxBizJgUseInfo, lambda);

                    // 上个代办改为已办
                    HashMap<String, Object> taskMap = new HashMap<>();
                    taskMap.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
                    taskMap.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
                    taskMap.put("relationId", jgTransferNotice.getInstanceId());
                    taskMap.put("flowStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
                    taskMap.put("flowStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
                    TaskMessageDto taskMessageDto = new TaskMessageDto();
                    BeanUtils.copyProperties(jgTransferNotice, taskMessageDto);
                    taskMap.put("model", taskMessageDto);
                    TaskV2Model taskV2Model1 = commonService.updateTaskModel(taskMap);

                    jgTransferNotice.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    jgTransferNotice.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
                    jgTransferNoticeMapper.updateById(jgTransferNotice);
                    //  创建设备履历
                    this.createResume(jgTransferNoticeEqs,jgTransferNotice, taskV2Model1.getRoutePath());
                    // 记录施工信息流水
                    this.createConstruction2Db(jgTransferNotice, jgTransferNoticeEqs);
                } else {
                    jgTransferNotice.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
                    jgTransferNotice.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    if (!ObjectUtils.isEmpty(jgTransferNotice.getInstanceStatus())) {
                        jgTransferNotice.setInstanceStatus(jgTransferNotice.getInstanceStatus() + "," + workflowResultDto.getNextExecutorRoleIds());
                    } else {
                        jgTransferNotice.setInstanceStatus(workflowResultDto.getNextExecutorRoleIds());
                    }
                    jgTransferNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                    // 上个代办改为已办
                    HashMap<String, Object> taskMap = new HashMap<>();
                    taskMap.put("taskStatus", FlowStatusEnum.TO_BE_PROCESSED.getCode());
                    taskMap.put("taskStatusLabel", FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskMap.put("flowStatus", FlowStatusEnum.TO_BE_PROCESSED.getCode());
                    taskMap.put("flowStatusLabel", FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskMap.put("relationId", jgTransferNotice.getInstanceId());
                    taskV2Model = commonService.updateTaskModel(taskMap);
                    TaskModelDto taskModelDto = new TaskModelDto();
                    BeanUtils.copyProperties(taskV2Model, taskModelDto);
                    // 创建新的代办
                    taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                    taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    taskModelDto.setFlowStatus(FlowStatusEnum.TO_BE_PROCESSED.getCode());
                    taskModelDto.setFlowStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskModelDto.setFlowCode(workflowResultDto.getNextTaskId());
                    taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                    TaskMessageDto taskMessageDto = new TaskMessageDto();
                    BeanUtils.copyProperties(jgTransferNotice, taskMessageDto);
                    taskModelDto.setModel(taskMessageDto);
                    commonService.buildTaskModel(Collections.singletonList(taskModelDto));
                    jgTransferNotice.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    jgTransferNotice.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
                    jgTransferNoticeMapper.updateById(jgTransferNotice);
                }
            } else {
                jgTransferNotice.setPromoter("");
                jgTransferNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.REJECTED.getCode()));
                // 上个代办改为已办
                HashMap<String, Object> taskMap = new HashMap<>();
                taskMap.put("taskStatus", jgTransferNotice.getNoticeStatus());
                taskMap.put("taskStatusLabel", FlowStatusEnum.REJECTED.getName());
                taskMap.put("relationId", jgTransferNotice.getInstanceId());
                taskMap.put("flowStatus", FlowStatusEnum.REJECTED.getCode());
                taskMap.put("flowStatusLabel", FlowStatusEnum.REJECTED.getName());
                taskV2Model = commonService.updateTaskModel(taskMap);
                TaskModelDto taskModelDto = new TaskModelDto();
                BeanUtils.copyProperties(taskV2Model, taskModelDto);
                // 创建新的代办
                taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                taskModelDto.setFlowStatus(FlowStatusEnum.REJECTED.getCode());
                taskModelDto.setFlowStatusLabel(FlowStatusEnum.REJECTED.getName());
                taskModelDto.setFlowCode(workflowResultDto.getNextTaskId());
                taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                taskModelDto.setPageType("edit");
                TaskMessageDto taskMessageDto = new TaskMessageDto();
                BeanUtils.copyProperties(jgTransferNotice, taskMessageDto);
                taskModelDto.setModel(taskMessageDto);
                commonService.buildTaskModel(Collections.singletonList(taskModelDto));
                jgTransferNotice.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                jgTransferNotice.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
                jgTransferNoticeMapper.updateById(jgTransferNotice);
            }
            commonService.saveExecuteFlowData2Redis(instanceId, this.buildInstanceRuntimeData(jgTransferNotice));
            this.delRepeatUseEquipData(jgTransferNotice);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    private void createResume(List<JgTransferNoticeEq> jgRelationEquips, JgTransferNotice notice, String routePath) {
        jgResumeInfoService.saveBatchResume(jgRelationEquips.stream().map(eq-> JgResumeInfoDto.builder().applyNo(notice.getApplyNo())
                .businessType(BusinessTypeEnum.JG_ADVICE_REMOVAL.getName())
                .businessId(String.valueOf(notice.getSequenceNbr()))
                .equId(eq.getEquId())
                .approvalUnit(notice.getReceiveOrgName())
                .approvalUnitCode(notice.getReceiveCompanyCode())
                .status("正常")
                .changeContent(BusinessTypeEnum.JG_ADVICE_REMOVAL.getName() + "业务办理")
                .routePath(routePath)
                .build()).collect(Collectors.toList())
        );
    }


    private void updateEq(JgTransferNotice jgTransferNotice) {
        // 组装设备注册代码
        String ym = null;
        try {
            ym = DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN_MM);
        } catch (ParseException e) {
            log.error("日期转换失败：{}", e);
        }
        List<JgTransferNoticeEq> eqList = jgTransferNoticeEqService.lambdaQuery().eq(JgTransferNoticeEq::getEquipTransferId, jgTransferNotice.getSequenceNbr().toString()).list();
        for (JgTransferNoticeEq eq : eqList) {
            RegistrationInfo tzsJgRegistrationInfo = tzsJgRegistrationInfoMapper.selectOne(
                    new LambdaQueryWrapper<RegistrationInfo>().eq(RegistrationInfo::getRecord, eq.getEquId()));
            String equCode = Optional.ofNullable(tzsJgRegistrationInfo.getEquDefine()).orElse(tzsJgRegistrationInfo.getEquCategory());
            String registrationCode = equCode + codeUtil.getCityRegionCode(jgTransferNotice.getReceiveCompanyCode()) + ym;
            ResponseModel<String> responseModel = tzsServiceFeignClient.deviceRegistrationCode(registrationCode);
            String deviceRegistrationCode = responseModel.getResult();
            eq.setInformNumber(deviceRegistrationCode);
        }
        jgTransferNoticeEqService.updateBatchById(eqList);
    }

    private void saveHisDataBeforeUpdate(JgTransferNotice jgTransferNotice, List<JgTransferNoticeEq> jgTransferNoticeEqs) {
        String seq = jgTransferNotice.getSequenceNbr().toString();
        JSONObject json = (JSONObject) JSONObject.toJSON(jgTransferNotice);
        List<String> ids = jgTransferNoticeEqs.stream().map(JgTransferNoticeEq::getEquId).collect(Collectors.toList());
        Iterable<ESEquipmentCategoryDto> allById = esEquipmentCategory.findAllById(ids);
        List<Map<String, Object>> equipListMaps = getEquipListMaps(allById);
        json.put("deviceList", equipListMaps);
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, seq);
        lambda.eq(JgRegistrationHistory::getIsDelete, false);
        Integer integer = jgRegistrationHistoryService.getBaseMapper().selectCount(lambda);
        if (integer > 0) {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(json));
            jgRegistrationHistoryService.update(jgRegistrationHistory, lambda);
        } else {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(json));
            jgRegistrationHistory.setStatus("new");
            jgRegistrationHistory.setRegistrationClass(BusinessTypeEnum.JG_ADVICE_REMOVAL.getName());
            jgRegistrationHistory.setCurrentDocumentId(seq);
            jgRegistrationHistoryService.save(jgRegistrationHistory);
        }
    }


    /**
     * 执行工作流并返回组装好的工作流信息
     *
     * @param op               是否通过
     * @param opinion          备注信息
     * @param jgTransferNotice 业务信息
     * @return 返回组装好的工作流信息
     */
    private WorkflowResultDto getWorkflowResultDto(String op, String opinion, JgTransferNotice jgTransferNotice) {
        ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
        WorkflowResultDto workflowResultDto = new WorkflowResultDto();
        // 只调用执行API，返回下个节点信息，用于填充业务字段
        //组装信息
        TaskResultDTO workDto = new TaskResultDTO();
        workDto.setResultCode("approvalStatus");
        workDto.setTaskId(jgTransferNotice.getNextTaskId());
        HashMap<String, Object> commMap = new HashMap<>();
        if (jgTransferNotice.getNoticeStatus().equals("6614") || jgTransferNotice.getNoticeStatus().equals("6615")) {
            commMap.put("approvalStatus", "提交");
        } else {
            commMap.put("approvalStatus", op);
        }
        workDto.setNextExecuteUserCompanyCode(jgTransferNotice.getReceiveOrgCode());
        workDto.setNextExecuteUserCompanyCode("1".equals(op) ? jgTransferNotice.getInstallUnitCreditCode() : jgTransferNotice.getReceiveOrgCode());
        workDto.setVariable(commMap);
        workDto.setComment(opinion);
        processTaskDTO = iCmWorkflowService.completeOrReject(jgTransferNotice.getNextTaskId(), workDto, op);
        // 提取节点等信息
        workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
        return workflowResultDto;
    }

    @Override
    public boolean beforeCheck(JgTransferNotice jgTransferNotice) {
        return jgTransferNotice.getInstanceId() != null && !jgTransferNotice.getNoticeStatus().equals(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode())) &&!jgTransferNotice.getNoticeStatus().equals(String.valueOf(FlowStatusEnum.TO_BE_DISCARD.getCode()));
    }

    @Override
    public void compensate(JgTransferNotice jgTransferNotice) {
        commonService.saveExecuteFlowData2Redis(jgTransferNotice.getInstanceId(), this.buildInstanceRuntimeData(jgTransferNotice));
    }

    private void createConstruction2Db(JgTransferNotice jgTransferNotice, List<JgTransferNoticeEq> jgTransferNoticeEqs) {
        List<IdxBizJgConstructionInfo> constructionInfoList = jgTransferNoticeEqs.stream().map(e->{
            IdxBizJgConstructionInfo idxBizJgConstructionInfo = new IdxBizJgConstructionInfo();
            idxBizJgConstructionInfo.setUscUnitCreditCode(jgTransferNotice.getInstallUnitCreditCode());
            idxBizJgConstructionInfo.setUscUnitName(jgTransferNotice.getInstallUnitName());
            idxBizJgConstructionInfo.setUscDate(jgTransferNotice.getPlanDate());
            idxBizJgConstructionInfo.setRecord(e.getEquId());
            idxBizJgConstructionInfo.setRecDate(new Date());
            idxBizJgConstructionInfo.setRecUserId(RequestContext.getExeUserId());
            idxBizJgConstructionInfo.setNoticeId(jgTransferNotice.getSequenceNbr() + "");
            idxBizJgConstructionInfo.setConstructionLeaderName(jgTransferNotice.getConstructionManager());
            idxBizJgConstructionInfo.setConstructionLeaderPhone(jgTransferNotice.getConstructionManagerPhone());
            idxBizJgConstructionInfo.setProxyStatementAttachment(jgTransferNotice.getPowerOfAttorney());
            idxBizJgConstructionInfo.setConstructionContractAttachment(jgTransferNotice.getConstructionContract());
            idxBizJgConstructionInfo.setConstructionOtherAccessories(jgTransferNotice.getOtherAccessories());
            idxBizJgConstructionInfo.setConstructionProvince(jgTransferNotice.getProvince());
            idxBizJgConstructionInfo.setConstructionCity(jgTransferNotice.getCity());
            idxBizJgConstructionInfo.setConstructionCounty(jgTransferNotice.getCounty());
            idxBizJgConstructionInfo.setConstructionStreet(jgTransferNotice.getFactoryUseSiteStreet());
            idxBizJgConstructionInfo.setConstructionAddress(jgTransferNotice.getAddress());
            idxBizJgConstructionInfo.setConstructionProvinceName(jgTransferNotice.getProvinceName());
            idxBizJgConstructionInfo.setConstructionCityName(jgTransferNotice.getCityName());
            idxBizJgConstructionInfo.setConstructionCountyName(jgTransferNotice.getCountyName());
            idxBizJgConstructionInfo.setConstructionStreetName(jgTransferNotice.getStreetName());
            idxBizJgConstructionInfo.setConstructionType(ConstructionTypeEnum.GZ.getCode());
            idxBizJgConstructionInfo.setConstructionIsXiXian(jgTransferNotice.getIsXixian());
            return idxBizJgConstructionInfo;
        }).collect(Collectors.toList());
        iIdxBizJgConstructionInfoService.saveBatch(constructionInfoList);
    }
}