package com.yeejoin.amos.boot.module.elevator.api.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

@Data
public class AlertRescueStatisticsExportVo {

    @ColumnWidth(10)
    @ExcelProperty(value = "序号", index = 0)
    private Integer number;

    /**
     * 监管单位名称
     */
    @ColumnWidth(30)
    @ExcelProperty(value = "区域", index = 1)
    private String supervisoryUnitName;

    /**
     * 维保单位数
     */
    @ExcelProperty(value = "派遣维保公司（家）", index = 2)
    private Integer maintenanceUnit;

    /**
     * 大于30分钟
     */
    @ExcelProperty(value = "超过30分钟到达（次）", index = 4)
    private Integer greaterNum;

    /**
     * 小于30分钟
     */
    @ExcelProperty(value = "30分钟内到达（次）", index = 3)
    private Integer lessNum;

    /**
     * 平均
     */
    @ColumnWidth(25)
    @ExcelProperty(value = "平均到达救援现场时间（min）", index = 5)
    private String avgNum;

    /**
     * 一级救援
     */
    @ExcelProperty(value = "一级救援次（次）", index = 6)
    private Integer levelOne;

    /**
     * 二级救援
     */
    @ExcelProperty(value = "二级救援（次）", index = 7)
    private Integer levelTwo;

    /**
     * 三级救援
     */
    @ExcelProperty(value = "三级救援（次）", index = 8)
    private Integer levelThree;


}
