package com.yeejoin.amos.boot.module.common.api.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;


/**
 * @description:
 * @author: tw
 * @createDate: 2021/10/20
 */
@FeignClient(name = "${video.fegin.name:video}", path = "video", configuration = {MultipartSupportConfig.class})
public interface VideoFeignClient {
    @RequestMapping(value = "/video-original/url/video/{indexCode}", method = RequestMethod.GET)
    ResponseModel<String> videoUrlByIndexCode(@PathVariable("indexCode") String indexCode);
}
