package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.ibatis.type.JdbcType;

import java.util.List;

/**
 * 管道删除历史表
 *
 * @author system_generator
 * @date 2025-06-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "idx_biz_jg_pipeline_operation_hist", autoResultMap = true)
public class IdxBizJgPipelineOperationHist extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 业务类型枚举
     */
	@TableField("biz_type")
    private String bizType;

    /**
     * 当前单据Id
     */
	@TableField("biz_id")
    private String bizId;

    /**
     * 原始的数据
     */
	@TableField("o_data")
    private String oData;

    /**
     * 插入的管道数据
     */
    @TableField(value = "insert_pipelines", typeHandler = JacksonTypeHandler.class, jdbcType = JdbcType.VARCHAR)
    private List<String> insertPipelines;

    /**
     * 删除的管道数据
     */
    @TableField(value = "delete_pipelines", typeHandler = JacksonTypeHandler.class, jdbcType = JdbcType.VARCHAR)
    private List<String> deletedPipelines;

    /**
     * 版本号
     */
    @TableField(value = "version")
    private Integer version;

}
