package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 设备保险信息
 *
 * @author LiuLin
 * @date 2024-10-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_equip_insurance")
public class JgEquipInsurance extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 设备id
     */
	@TableField("equ_id")
    private String equId;

    /**
     * 承保单位名称
     */
	@TableField("under_write_name")
    private String underWriteName;

    /**
     * 承保单位统一信用代码
     */
	@TableField("under_write_credit_code")
    private String underWriteCreditCode;

    /**
     * 保险服务单位
     */
	@TableField("insurance_service_unit_name")
    private String insuranceServiceUnitName;

    /**
     * 保险服务单位统一社会信用代码
     */
	@TableField("insurance_service_unit_code")
    private String insuranceServiceUnitCode;

    /**
     * 理赔电话
     */
	@TableField("claim_telephone")
    private String claimTelephone;

    /**
     * 保险单号
     */
	@TableField("insurance_number")
    private String insuranceNumber;

    /**
     * 保险截止日期
     */
	@TableField("insurance_expiration_date")
    private Date insuranceExpirationDate;

    /**
     * 设备种类
     */
    @TableField("equ_list")
    private String equList;

    /**
     * 设备类别
     */
    @TableField("equ_category")
    private String equCategory;

    /**
     * 设备品种
     */
    @TableField("equ_define")
    private String equDefine;
}
