package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.factory;


import com.yeejoin.amos.boot.module.jg.biz.reminder.biz.strategy.GradeCalculationStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
public class GradeStrategyFactory {
    private final Map<String, GradeCalculationStrategy> strategyMap;

    @Autowired
    public GradeStrategyFactory(List<GradeCalculationStrategy> strategies) {
        this.strategyMap = strategies.stream()
                .collect(Collectors.toMap(
                        GradeCalculationStrategy::getStrategyType,
                        Function.identity()
                ));
    }

    public GradeCalculationStrategy getStrategy(String strategyType) {
        return Optional.ofNullable(strategyMap.get(strategyType))
                .orElseThrow(() -> new IllegalArgumentException(
                        String.format("No strategy found for type: %s. Available: %s",
                                strategyType,
                                strategyMap.keySet())
                ));
    }

}
