package com.yeejoin.amos.boot.module.common.api.service;

import com.yeejoin.amos.boot.module.common.api.dto.KeySiteDateDto;
import com.yeejoin.amos.boot.module.common.api.dto.KeySiteDto;
import com.yeejoin.amos.boot.module.common.api.dto.KeySiteExcleDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgMenuDto;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import java.util.List;

/**
 * 重点部位接口类
 *
 * @author system_generator
 * @date 2021-07-26
 */
public interface IKeySiteService {
/**
 * 根据主键做逻辑假删除
 * @param id
 * @return
 */
	public boolean deleteById(List<Long> sequenceNbrList);
/**
 * 保存
 * @param model
 * @return
 */
public KeySiteDto save(KeySiteDto model);
/**
 * 修改
 * @param keySite
 * @return
 */
public boolean update(KeySiteDto keySite, AgencyUserModel userInfo) ;
/**
 * 获取机场单位部位树，包含单位下所包含的部位的统计
 * @return
 */
public  List<OrgMenuDto> getOrguserTree();
/**
 * 
 * @return
 */
public List<KeySiteDto> queryForKeySiteList() ;
/**根据id查找
 * 
 * @param sequenceNbr
 * @return
 */
public KeySiteDto getSequenceNbr(Long sequenceNbr);

public List<KeySiteExcleDto> exportToExcel();

/**获取所在建筑的树结构信息
 * 
 * @return
 */
public List<Object> getBuildTree() ;

public boolean saveExcel(List<KeySiteExcleDto> excelDtoList);
/**
 * 获取所在建筑的建筑部位树
 * @param sequenceNbr 所在建筑的id
 * @return
 */
public  List<OrgMenuDto> getBuildAndKeyTree(Long sequenceNbr);

public  List<KeySiteDateDto> getKeySiteDate(Long id);


}
