package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersContractDto;
import com.yeejoin.amos.boot.module.common.api.entity.FirefightersContract;
import com.yeejoin.amos.boot.module.common.api.entity.SourceFile;
import com.yeejoin.amos.boot.module.common.api.mapper.FirefightersContractMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFirefightersContractService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
* 消防员合同 服务实现类
*
* @author tb
* @date 2021-06-07
*/
@Service
public class FirefightersContractServiceImpl extends BaseService<FirefightersContractDto,FirefightersContract,FirefightersContractMapper> implements IFirefightersContractService {


	@Autowired
	SourceFileServiceImpl sourceFileService;
	@Autowired
	private Sequence sequence;
	@Autowired
	DataDictionaryServiceImpl iDataDictionaryService;

	@Override
	@Transactional(rollbackFor = Exception.class)
	public FirefightersContractDto save(FirefightersContractDto firefightersContract) {

		long sequenceId = sequence.nextId();
		FirefightersContract detail=new FirefightersContract();

		/* BUG 2193  LITW  start*/
		DataDictionary dataDictionary = iDataDictionaryService.getById(firefightersContract.getContractTypeCode());
		if(null !=dataDictionary ) {
			detail.setContractType(dataDictionary.getName());
		}
		/* BUG 2193  LITW  end*/
		Bean.copyExistPropertis(firefightersContract, detail);
		firefightersContract.setSequenceNbr(sequenceId);
		detail.setSequenceNbr(sequenceId);
		this.save(detail);
		saveAttachments(firefightersContract);
		return firefightersContract;
	}
	
	
	public void saveAttachments(FirefightersContractDto firefightersContract) {
		if (!ValidationUtil.isEmpty(firefightersContract.getAttachments())) {
			List<SourceFile> sourceFiles = Lists.newArrayList();
			Map<String, List<AttachmentDto>> attachmentMap = firefightersContract.getAttachments();
			attachmentMap.entrySet().forEach(entry -> {
				List<AttachmentDto> atts = entry.getValue();
				sourceFiles.addAll(attachment2SourceFile(entry.getKey(), atts));
			});
			sourceFileService.saveSourceFile(firefightersContract.getSequenceNbr(), sourceFiles);
		}
	}

	private List<SourceFile> attachment2SourceFile(String type, List<AttachmentDto> attachmentDtoList) {
		List<SourceFile> sourceFiles = Lists.newArrayList();
		if (!ValidationUtil.isEmpty(attachmentDtoList)) {
			attachmentDtoList.forEach(a -> {
				SourceFile s = new SourceFile();
				s.setFilePath(a.getUrl());
				s.setFileName(a.getName());
				s.setFileCategory(type);
				sourceFiles.add(s);
			});
		}
		return sourceFiles;
	}


	@Override
	@Transactional(rollbackFor = Exception.class)
	public FirefightersContractDto updateById(FirefightersContractDto firefightersContract, AgencyUserModel userInfo) {
		FirefightersContract detail=new FirefightersContract();
		Bean.copyExistPropertis(firefightersContract, detail);
		detail.setIsDelete(false);
		detail.setRecDate(new Date());
		detail.setRecUserId(userInfo.getUserId());
		detail.setRecUserName(userInfo.getUserName());
		this.baseMapper.updateById(detail);
		Map<String, List<AttachmentDto>> map = firefightersContract.getAttachments();
		if (ObjectUtils.isNotEmpty(map)) {
			this.saveAttachments(firefightersContract);
		}
		return firefightersContract;
	}

}
