package com.yeejoin.amos.supervision.business.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.supervision.business.service.intfc.IPlanAuditService;
import com.yeejoin.amos.supervision.business.util.CommonResponse;
import com.yeejoin.amos.supervision.business.util.CommonResponseUtil;
import com.yeejoin.amos.supervision.core.framework.PersonIdentify;
import com.yeejoin.amos.supervision.dao.entity.PlanAuditLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

@RestController
@RequestMapping(value = "/api/planAudit")
@Api(tags = "计划审核api")
public class PlanAuditController extends AbstractBaseController {

    private final Logger log = LoggerFactory.getLogger(PlanAuditController.class);

    @Autowired
    private IPlanAuditService planAuditService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PersonIdentify
    @ApiOperation(value = "计划工作流审核", notes = "计划工作流审核")
    @RequestMapping(value = "/auditWorkFlow", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse auditWorkFlow(
            @ApiParam(value = "工作流流水实例", required = true) @RequestBody PlanAuditLog planAuditLog,
            @ApiParam(value = "执行控制条件", required = true) @RequestParam String condition) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            return CommonResponseUtil.success(planAuditService.auditWorkFlow(planAuditLog, condition, reginParams));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("计划工作流审核失败！");
        }
    }

}
