package com.yeejoin.amos.supervision.business.dao.repository;

import com.yeejoin.amos.supervision.dao.entity.HiddenDanger;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("iHiddenDangerDao")
public interface IHiddenDangerDao extends BaseDao<HiddenDanger, Long> {
    /**
     * 按照唯一索引查询
     *
     * @param latentDangerId 隐患模块id
     * @return HiddenDanger
     */
    HiddenDanger findByLatentDangerId(Long latentDangerId);

    /**
     * 查询批量
     * @param ids 隐患ids
     * @return List<HiddenDanger>
     */
    List<HiddenDanger> findByLatentDangerIdIn(List<Long> ids);
}
