package com.yeejoin.amos.supervision.business.feign;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.supervision.core.common.dto.DangerDto;
import org.apache.ibatis.annotations.Delete;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
@FeignClient(value = "AMOS-LATENT-DANGER", path = "latentDanger/api/latent/danger", configuration = FeignConfiguration.class)
public interface DangerFeignClient {

    /**
     * 隐患详情
     *
     * @param dangerId 隐患主键
     * @return FeignClientResult
     */
    @GetMapping(value = "/detail")
    FeignClientResult<DangerDto> getOne(@RequestParam Long dangerId);


    /**
     * 隐患的创建或者更新
     *
     * @param latentDangerDtoList 隐患对象数组
     * @return FeignClientResult
     */
    @PostMapping(value = "/patrol/save")
    FeignClientResult<List<DangerDto>> saveOrUpdateBatch(@RequestBody List<DangerDto> latentDangerDtoList);

    /**
     * 隐患分页查询
     *
     * @param page        分页信息
     * @param ids         隐患ids
     * @param dangerLevel 隐患级别
     * @param dangerState 隐患状态
     * @return FeignClientResult
     */
    @GetMapping(value = "/page/list")
    FeignClientResult<Page<DangerDto>> pageList(Page page, @RequestParam String ids, @RequestParam(required = false) String dangerLevel, @RequestParam(required = false) String dangerState);


    /**
     * 查询所有的隐患
     *
     * @param ids         隐患ids
     * @param dangerLevel 隐患级别
     * @param dangerState 隐患状态
     * @return FeignClientResult
     */
    @GetMapping(value = "/list/all")
    FeignClientResult<List<DangerDto>> listAll(@RequestBody Map param);

    /**
     * 隐患等级
     *
     * @return List<Object>
     */
    @GetMapping(value = "/dangerLevel")
    FeignClientResult<Collection<DictionarieValueModel>> getDangerLevelData();

    /**
     * 治理方式
     *
     * @return List<Object>
     */
    @GetMapping(value = "/dangerGovernance")
    FeignClientResult<Collection<DictionarieValueModel>> getDangerGovernanceData();

    /**
     * 批量删除
     * @param ids 隐患ids
     * @return Boolean
     */
    @DeleteMapping("/delete")
    FeignClientResult<Boolean> deleteDangerBatch(@RequestParam String ids);
}
