package com.yeejoin.equipmanage.common.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 库存台账
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_stock")
@ApiModel(value = "Stock对象", description = "库存台账")
public class Stock extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "仓库ID")
	private Long warehouseId;

	@ApiModelProperty(value = "装备定义ID")
	private Long equipmentDetailId;

	@ApiModelProperty(value = "库存数量")
	private Double amount;

	@ApiModelProperty(value = "公司名称")
	@TableField(value = "company_name", fill = FieldFill.INSERT)
	private String companyName;

	@ApiModelProperty(value = "公司code")
	@TableField(value = "org_code", fill = FieldFill.INSERT)
	private String orgCode;

	@ApiModelProperty(value = "部门名称")
	@TableField(value = "department_name", fill = FieldFill.INSERT)
	private String departmentName;

	@ApiModelProperty(value = "部门code")
	@TableField(value = "department_orgcode", fill = FieldFill.INSERT)
	private String departmentOrgcode;

}
