package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.ProjectDto;
import com.yeejoin.precontrol.common.entity.Project;
import com.yeejoin.precontrol.common.entity.ProjectCoordinate;
import com.yeejoin.precontrol.common.vo.BadProjectVo;
import com.yeejoin.precontrol.common.vo.ProjectVo;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/**
 * 项目信息 服务类
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface IProjectService extends IService<Project> {
    /**
     * 项目列表查询
     * @param pageable
     * @param projectDto
     * @return
     */
    IPage<ProjectVo> listByPage(CommonPageableDto pageable, ProjectDto projectDto);


    /**
     * 项目选择
      * @return
     */
    List<HashMap<String, Object>> projectSelect();

    /**
     * 安全态势分计算
     *
     * @param projectId
     * @return
     */
    Integer securityScore(Long projectId);

    /**
     * 地图连线
     * @return
     */
    Object getMapLine(String orgCode, Long projectId) throws IOException;

    /**
     * 违规项目系数
     * @param isBad
     * @param isAllStatus
     * @param pageable
     * @param badProjectVo
     * @return
     */
    IPage<BadProjectVo> pageBadProject(boolean isBad, boolean isAllStatus, CommonPageableDto pageable,
                                       BadProjectVo badProjectVo);


    /**
     * 根据ID查询项目
     * @param id
     * @return
     */
    Object selectById(Long id,Long companyId);

    /**
     * 项目导入
     * @param file
     * @return
     * @throws Exception
     */
    List<Project> projectImport(MultipartFile file) throws Exception;


    /**
     * 根据平台项目部id查询项目的id
     * @param id
     * @return
     */
    List<Long> listByPlatformOrgCode(String orgcode);


    /**
     * 保存项目坐标信息
     * @param project
     * @return
     */
    void saveProject(ProjectDto project);

    /**
     * 根据id修改项目信息和坐标信息
     * @param project
     */
    void updateById(ProjectDto project);

    /**
     * 根据项目id删除项目信息和坐标信息
     * @param id
     */
    boolean removeById(Long id);

    /**
     * 根据项目id批量删除项目信息和坐标信息
     * @param ids
     */
    boolean removeByIds(List<Long> ids);

    /**
     * 根据导入的数据保存项目信息和坐标信息
     * @param data
     * @return
     */
    Boolean saveProjectImportData(List<Project> data);
}
