package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.MenuFrom;
import com.yeejoin.amos.boot.module.common.api.entity.SpecialPositionStaff;
import com.yeejoin.amos.boot.module.common.api.mapper.SpecialPositionStaffMapper;
import com.yeejoin.amos.boot.module.common.api.service.ISpecialPositionStaffService;
import com.yeejoin.amos.boot.module.common.api.dto.SpecialPositionStaffDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 特岗人员服务实现类
 *
 * @author system_generator
 * @date 2021-07-23
 */
@Service
public class SpecialPositionStaffServiceImpl extends BaseService<SpecialPositionStaffDto, SpecialPositionStaff,
        SpecialPositionStaffMapper> implements ISpecialPositionStaffService {

    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;

    /**
     * 分页查询
     */
    public Page<SpecialPositionStaffDto> queryForSpecialPositionStaffPage(Page<SpecialPositionStaffDto> page,
                                                                          @Condition(Operator.eq) Long companyId,
                                                                          @Condition(Operator.eq) Boolean isDelete,
                                                                          @Condition(Operator.eq) String positionNameCode) {
        return this.queryForPage(page, null, false, companyId, isDelete, positionNameCode);
    }

    /**
     * 列表查询 示例
     */
    public List<SpecialPositionStaffDto> queryForSpecialPositionStaffList() {
        return this.queryForList("", false);
    }

    /**
     * 批量删除
     *
     * @param sequenceNbrList
     * @return
     */
    public Boolean batchDelete(List<Long> sequenceNbrList) {
        List<SpecialPositionStaff> positionStaffList =
                list(new LambdaQueryWrapper<SpecialPositionStaff>().in(SpecialPositionStaff::getSequenceNbr,
                        sequenceNbrList));
        positionStaffList.forEach(item -> item.setIsDelete(true));
        boolean update = updateBatchById(positionStaffList);
        return update;
    }

    public HashMap<Object, Object> getSpecialPositionStaffList(Long companyId) throws Exception {
        // 查询所有岗位类型
        List<MenuFrom> menuList = dataDictionaryService.getGWMCDataDictionary("GWMC");
        // 查询已有数据的岗位类型
        List<Long> positionStaffCodeList = this.baseMapper.getPositionStaffCodeList(false,companyId);
        // 排除已有数据的，返回
        /*bug 3483 陈召 2021-11-18 开始*/
        for (int i = 0; i < menuList.size(); i++) {
            //排除父岗位是否已有 有就删除
            if (positionStaffCodeList.contains(Long.valueOf(menuList.get(i).getKey()))) {
                menuList.remove(i);
                i--;
            }
            //排除子岗位是否已有 有就删除
            if (null != menuList.get(i).getChildren() && menuList.get(i).getChildren().size() > 0){
                List<MenuFrom> children = menuList.get(i).getChildren();
                for (int j= 0; j < children.size(); j++) {
                    if (positionStaffCodeList.contains(Long.valueOf(children.get(j).getKey()))) {
                        menuList.get(i).getChildren().remove(j);
                        j--;
                    }
                    //当子岗位全部删除时 父岗位也删除
                    if (children.size() == 0){
                        menuList.remove(i);
                        i--;
                    }
                }
            }
        }
        /*bug 3483 陈召 2021-11-18 结束*/
        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        objectObjectHashMap.put("GWMC", menuList);
        return objectObjectHashMap;
    }
}