package com.yeejoin.amos.boot.module.jcs.biz.rule.action;


import java.util.*;

import com.yeejoin.amos.boot.module.jcs.biz.service.impl.PowerrTransferLogServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCallePowerTransferRo;
import com.yeejoin.amos.boot.module.jcs.api.enums.FireBrigadeTypeEnum;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.AlertSubmittedServiceImpl;
import com.yeejoin.amos.component.rule.RuleActionBean;
import com.yeejoin.amos.component.rule.RuleMethod;

/**
 * <pre>
 * 警情报送规则动作
 * </pre>
 *
 * @author gwb
 * @version $Id: AlertCalledAction.java, v 0.1 2021年6月24日 下午4:41:22 gwb Exp $
 */
@Component
@RuleActionBean(beanLabel = "调派报送")
public class PowerTransferAction {

    /**
	 * 
	 */

	public static final Logger log = LoggerFactory.getLogger(PowerTransferAction.class);

    @Autowired
    private AlertSubmittedServiceImpl alertSubmittedService;


	@Autowired
	PowerrTransferLogServiceImpl powerrTransferLogServiceImpl;



    /**
     * 短信报送
     *
     * @param smsCode  短信模板code
     * @param sendType 发送类型
     * @param sendIds  人员id
     * @param object   模板内容对象
     * @throws Exception 异常
     */
    @SuppressWarnings("rawtypes")
	@RuleMethod(methodLabel = "短信报送", project = "西咸机场119接处警规则")
    public void sendcmd(String smsCode, String sendType, List sendIds, Object object) throws Exception {
    	if (object instanceof AlertCallePowerTransferRo) {

			AlertCallePowerTransferRo calledRo = (AlertCallePowerTransferRo) object;
			// 获取力量调派发送人员
			List<String> persons = new ArrayList<>();
			List<Map<String, Object>> personslist = new ArrayList<Map<String, Object>>();
			if (FireBrigadeTypeEnum.专职消防队.getKey().equals(calledRo.getPowerTransType())) {
				 alertSubmittedService.ruleCallbackActionForPowerTransferForCar(smsCode, sendIds, object,personslist);//消防车辆
			} else if (FireBrigadeTypeEnum.医疗救援队.getKey().equals(calledRo.getPowerTransType())) {
			    alertSubmittedService.ruleCallbackActionForPowerTransferForAid(smsCode, sendIds, object,personslist);//120急救站
			} else if (FireBrigadeTypeEnum.监控大队.getKey().equals(calledRo.getPowerTransType())) {
				 alertSubmittedService.ruleCallbackActionForPowerTransferForSurvBrigade(smsCode, sendIds, object,personslist);//监控大队
			}
			persons=getwone(personslist);
			powerrTransferLogServiceImpl.savePowerTransferLog(calledRo,persons);

    	}
    }


	public List<String> getwone(List<Map<String, Object>> sendUserIds){
		List<String> persons = new ArrayList<>();
		Map<String,Map<String, Object>> map =new HashMap<>();
		if(sendUserIds!=null&&sendUserIds.size()>0){
			for (Map<String, Object> sendUserId : sendUserIds) {
				map.put(sendUserId.get("userId").toString(),sendUserId);
			}
		}
		Set<Map<String, Object>> set  = new HashSet<>(map.values());
		for (Map<String, Object> stringObjectMap : set) {
			persons.add(stringObjectMap.get("userName").toString());
		}
		return  persons;
	}
}
