package com.yeejoin.amos.api.openapi.face.orm.entity;

import java.io.Serializable;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 企业数据信息
 *
 * @author duanwei
 * @date 2022-07-20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("tm_jg_enterprise_info")
@ApiModel(value="TmJgEnterpriseInfo对象", description="企业数据信息")
public class EnterpriseInfo extends AbstractBaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "使用单位唯一标识")

    private String useUnitCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "使用单位证件类型")
    private String useUnitCertificate;

    @ApiModelProperty(value = "使用单位代码")
    private String useCode;

    @ApiModelProperty(value = "使用单位名称")
    private String useUnit;

    @ApiModelProperty(value = "是否重点监控单位")
    private String keyUnit;

    @ApiModelProperty(value = "重点场所分类")
    private String classPlaces;

    @ApiModelProperty(value = "单位所在省份名称")
    private String province;

    @ApiModelProperty(value = "单位所在城市名称")
    private String city;

    @ApiModelProperty(value = "单位所在区县名称")
    private String district;

    @ApiModelProperty(value = "单位所在街道名称")
    private String street;

    @ApiModelProperty(value = "单位所在社区名称")
    private String community;

    @ApiModelProperty(value = "单位详细地址")
    private String address;

    @ApiModelProperty(value = "使用单位法人")
    private String legalPerson;

    @ApiModelProperty(value = "法人联系电话")
    private String legalPhone;

    @ApiModelProperty(value = "使用单位联系人")
    private String useContact;

    @ApiModelProperty(value = "联系人联系电话")
    private String contactPhone;

    @ApiModelProperty(value = "安全管理人员1姓名")
    private String safetyOne;

    @ApiModelProperty(value = "安全管理人员1身份证")
    private String safetyOneId;

    @ApiModelProperty(value = "安全管理人员1联系电话")
    private String safetyOnePhone;

    @ApiModelProperty(value = "安全管理人员2")
    private String safetyTwo;

    @ApiModelProperty(value = "安全管理人员2身份证")
    private String safetyTwoId;

    @ApiModelProperty(value = "安全管理人员2联系电话")
    private String safetyTwoPhone;

    @ApiModelProperty(value = "单位地理坐标经度")
    private String longitude;

    @ApiModelProperty(value = "单位地理坐标纬度")
    private String latitude;

}
