package com.yeejoin.amos.api.openapi.face.service;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.api.openapi.enums.JgFileAttributeEnum;
import com.yeejoin.amos.api.openapi.enums.JgFileObjectEnum;
import com.yeejoin.amos.api.openapi.face.model.DesignInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.DesignInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.DesignInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.File;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 特种设备基本信息-设计信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class DesignInfoService extends AppBaseService<DesignInfoModel, DesignInfo, DesignInfoMapper>{

    @Autowired
    private FileService fileService;

    /**
     *
     * 新增设计信息
     *
     * @param model 设计信息model集合
     * @return  成功返回“ok” 失败返回“Access_token无效”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveDesignInfo(List<DesignInfoModel> model) {
        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("设计信息为空.");
        }


        List<DesignInfo> desList = new ArrayList<>();
        List<File> fileList = new ArrayList<>();
        List<File> designCodeList , designFileList;

        for (DesignInfoModel designInfoModel : model) {
            DesignInfo designInfo = new DesignInfo();
            checkModel(designInfoModel);
            designInfoModel.setRecDate(new Date());
            designInfoModel.setAppId(getAppId());

            designFileList = JSONObject.parseArray(JSONObject.toJSONString(designInfoModel.getDesignFile()),File.class);
            designCodeList = JSONObject.parseArray(JSONObject.toJSONString(designInfoModel.getDesignCode()),File.class);

            for (File files : designFileList) {
                File file = new File();
                file.setSequenceCode(designInfoModel.getSequenceCode());
                file.setAppId(getAppId());
                file.setObjectType(JgFileObjectEnum.DESIGN_INFO.getObject());
                file.setAttributeType(JgFileAttributeEnum.DESIGN_FILE.getAttribute());
                file.setSyncDate(designInfoModel.getSyncDate());
                file.setFileUrl(files.getFileUrl());
                file.setFileName(files.getFileName());
                file.setRecDate(new Date());
                fileList.add(file);
            }

            for (File files : designCodeList) {
                File file = new File();
                file.setSequenceCode(designInfoModel.getSequenceCode());
                file.setAppId(getAppId());
                file.setObjectType(JgFileObjectEnum.DESIGN_INFO.getObject());
                file.setAttributeType(JgFileAttributeEnum.DESIGN_CODE.getAttribute());
                file.setSyncDate(designInfoModel.getSyncDate());
                file.setFileUrl(files.getFileUrl());
                file.setFileName(files.getFileName());
                file.setRecDate(new Date());
                fileList.add(file);
            }

            BeanUtils.copyProperties(designInfoModel,designInfo);
            desList.add(designInfo);

        }
        this.saveBatch(desList);
        fileService.saveBatch(fileList);
        return "OK";
    }

    /**
     * 信息校验
     *
     * @param models
     */
    private static void checkModel(DesignInfoModel models) {
        if(ValidationUtil.isEmpty(models.getSequenceCode())) {
            throw new BadRequest("设备唯一标识码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监管系统唯一编码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getDesignUnitCreditCode())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设计单位统一社会信用代码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getDesignUnitName())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设计单位名称不能为空！");
        }
        if (ValidationUtil.isEmpty(models.getDesignUseDate())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设计使用年限不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSyncDate())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步时间不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSyncState())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步状态不能为空！");
        }
    }
}
