package com.yeejoin.amos.api.openapi.face.service;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.api.openapi.enums.JgFileAttributeEnum;
import com.yeejoin.amos.api.openapi.enums.JgFileObjectEnum;
import com.yeejoin.amos.api.openapi.face.model.InspectionInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.InspectionInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.File;
import com.yeejoin.amos.api.openapi.face.orm.entity.InspectionInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 特种设备检验信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class InspectionInfoService extends AppBaseService<InspectionInfoModel, InspectionInfo, InspectionInfoMapper> {

    @Autowired
    private FileService fileService;

    /**
     *
     * 新增特种设备检验信息
     *
     * @param model 特种设备检验信息model集合
     * @return  成功返回“ok” 失败返回“Access_token无效”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveInspectionInfo(List<InspectionInfoModel> model) {
        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("特种设备检验信息为空.");
        }

        List<InspectionInfo> insList = new ArrayList<>();
        List<File> fileList = new ArrayList<>();
        List<File> inspectionReportList;

        for (InspectionInfoModel models : model) {
            InspectionInfo inspectionInfo = new InspectionInfo();

            models.setRecDate(new Date());
            models.setAppId(getAppId());
            checkModel(models);
            inspectionReportList = JSONObject.parseArray(JSONObject.toJSONString(models.getInspectionReport()),File.class);

            for (File files : inspectionReportList) {
                File file = new File();
                file.setSequenceCode(models.getSequenceCode());
                file.setAppId(getAppId());
                file.setObjectType(JgFileObjectEnum.INSPECTION_INFO.getObject());
                file.setAttributeType(JgFileAttributeEnum.INSPECTION_REPORT.getAttribute());
                file.setSyncDate(models.getSyncDate());
                file.setFileUrl(files.getFileUrl());
                file.setFileName(files.getFileName());
                file.setRecDate(new Date());
                fileList.add(file);
            }

            BeanUtils.copyProperties(models,inspectionInfo);
            insList.add(inspectionInfo);
        }
        this.saveBatch(insList);
        fileService.saveBatch(fileList);
        return "OK";
    }

    /**
     * 信息校验
     *
     * @param models
     */
    private static void checkModel(InspectionInfoModel models) {
        if(ValidationUtil.isEmpty(models.getSequenceCode())) {
            throw new BadRequest("设备唯一标识码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监管系统唯一编码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getEquCode())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备代码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getInspectOrgName())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"检验机构名称不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getInspectConclusion())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"检验结论(合格，复检合格等)不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getInspectType())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"检验类型不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getInspectReportNum())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"检验报告ID不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getInspectStaff())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"检验人员不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getInspectDate())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"检验日期不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getProblemRemark())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"检验问题备注不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getNextInspectDate())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"下次检验日期不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getInspectionReport())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"检验报告附件不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSyncDate())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步时间不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSyncState())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步状态不能为空！");
        }
    }
}
