package com.yeejoin.amos.supervision.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the p_plan_task_detail database table.
 * 
 */
@Entity
@Table(name="p_plan_task_detail")
@NamedQuery(name="PlanTaskDetail.findAll", query="SELECT p FROM PlanTaskDetail p")
public class PlanTaskDetail extends BasicEntity {
	private static final long serialVersionUID = 1L;
	/**
	 * 是否完成：是否完成0-未完成，1-已完成，2-超时漏检
	 */
	@Column(name="is_finish")
	private int isFinish;
	/**
	 * 点编号
	 */
	@Column(name="point_id")
	private long pointId;
	/**
	 * 任务批次号
	 */
	@Column(name="task_no")
	private long taskNo;
	
	/**
	 * 具体执行人id
	 */
	@Column(name="executor_id")
	private String executorId;
	
	/**
	 * 执行时间
	 */
	@Column(name="executor_date")
	private Date executorDate;
	
	private PlanTask planTask;
	
	/**
	 * 状态：0 未开始；1 合格；2 不合格；3 漏检
	 */
	@Column(name="status")
	private String status="0";

	/**
	 * 检查项个数
	 */
	@Column(name="item_num")
	private int itemNum;

	/**
	 * 已执行个数
	 */
	@Column(name="executed_num")
	private int executedNum;

	/**
	 * 已执行个数
	 */
	@Column(name="safety_danger_num")
	private int safetyDangerNum;

	/**
	 * 已执行个数
	 */
	@Column(name="major_danger_num")
	private int majorDangerNum;

	public PlanTaskDetail() {
	}


	public int getIsFinish() {
		return this.isFinish;
	}

	public void setIsFinish(int isFinish) {
		this.isFinish = isFinish;
	}

	public long getPointId() {
		return this.pointId;
	}

	public void setPointId(long pointId) {
		this.pointId = pointId;
	}

	public long getTaskNo() {
		return this.taskNo;
	}

	public void setTaskNo(long taskNo) {
		this.taskNo = taskNo;
	}

	@ManyToOne
	@JoinColumn(name = "taskNo", referencedColumnName = "id", updatable = false, insertable = false)
	public PlanTask getPlanTask() {
		return planTask;
	}


	public void setPlanTask(PlanTask planTask) {
		this.planTask = planTask;
	}


	public String getStatus() {
		return status;
	}


	public void setStatus(String status) {
		this.status = status;
	}
	

	public String getExecutorId() {
		return executorId;
	}

	public void setExecutorId(String executorId) {
		this.executorId = executorId;
	}


	public int getItemNum() {
		return itemNum;
	}

	public void setItemNum(int itemNum) {
		this.itemNum = itemNum;
	}

	public int getExecutedNum() {
		return executedNum;
	}

	public void setExecutedNum(int executedNum) {
		this.executedNum = executedNum;
	}

	public Date getExecutorDate() {
		return executorDate;
	}

	public void setExecutorDate(Date executorDate) {
		this.executorDate = executorDate;
	}

	public int getSafetyDangerNum() {
		return safetyDangerNum;
	}

	public void setSafetyDangerNum(int safetyDangerNum) {
		this.safetyDangerNum = safetyDangerNum;
	}

	public int getMajorDangerNum() {
		return majorDangerNum;
	}

	public void setMajorDangerNum(int majorDangerNum) {
		this.majorDangerNum = majorDangerNum;
	}
}