package com.yeejoin.amos.boot.module.tzs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgConstructionInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgDesignInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgInspectionInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgMaintenanceInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgOtherInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgProduceInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgRegistrationInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgSuperviseInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgUseInfo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class TzsJgBasicInfoDto extends BaseDto {

	@ApiModelProperty(value = "设备唯一标识码")
	private String sequenceCode;

	@ApiModelProperty(value = "监管系统唯一编码")
	private String superviseCode;

	@ApiModelProperty(value = "管辖分局名称")
	private String orgBranchName;

	@ApiModelProperty(value = "使用单位名称")
	private String useUnitName;

	@ApiModelProperty(value = "维保单位名称")
	private String meUnitName;

	@ApiModelProperty(value = "产权单位名称")
	private String estateUnitName;

	@ApiModelProperty(value = "设备代码")
	private String equCode;

//	@ApiModelProperty(value = "设备种类")
//	private String equList;

	@ApiModelProperty(value = "设备类别")
	private String equCategory;

	@ApiModelProperty(value = "设备品种")
	private String equDefine;

	@ApiModelProperty(value = "96333识别码(七位电梯应急救援识别码)")
	private String code96333;

	@ApiModelProperty(value = "使用登记证编号")
	private String useOrgCode;

	@ApiModelProperty(value = "出厂编号")
	private String factoryNum;

	@ApiModelProperty(value = "设备所在区域 省/市/区")
	private String area;

	@ApiModelProperty(value = "设备详细使用地址")
	private String address;

	@ApiModelProperty(value = "管辖分局组织机构代码")
	private String orgBranchCode;

	@ApiModelProperty(value = "监督管理信息")
	private TzsJgSuperviseInfoDto superviseInfo;

	@ApiModelProperty(value = "设计信息")
	private TzsJgDesignInfoDto designInfo;

	@ApiModelProperty(value = "制造信息")
	private TzsJgProduceInfoDto produceInfo;

	@ApiModelProperty(value = "注册登记信息")
	private TzsJgRegistrationInfoDto registrationInfo;

	@ApiModelProperty(value = "使用信息")
	private TzsJgUseInfoDto useInfo;

	@ApiModelProperty(value = "施工信息-最新一次")
	private TzsJgConstructionInfoDto constructionInfo;

	@ApiModelProperty(value = "维保信息")
	private TzsJgMaintenanceInfoDto maintenanceInfo;

	@ApiModelProperty(value = "技术信息")
	private TzsJgElevatorTechInfoDto elevatorTechInfo;

	@ApiModelProperty(value = "检验信息")
	private TzsJgInspectionInfoDto inspectionInfo;

	
	@ApiModelProperty(value = "其他信息")
	private TzsJgOtherInfoDto otherInfo;
}
